#include <ETH.h> 
#include <WiFiUdp.h> 
#include <DS18B20.h>
DS18B20 ds1(14);  //channel-1-DS18b20
DS18B20 ds2(13);  //channel-2-DS18b20

DS18B20 ds3(32);  //channel-3-DS18b20
DS18B20 ds4(33);  //channel-4-DS18b20

#include "Arduino.h"
#include "PCF8574.h"

#include <RCSwitch.h>
RCSwitch mySwitch = RCSwitch();

#define ANALOG_A1   34
#define ANALOG_A2   35

// Set i2c address
PCF8574 pcf8574o(0x24);
PCF8574 pcf8574i(0x22);

#define ETH_ADDR        0
#define ETH_POWER_PIN  -1
#define ETH_MDC_PIN    23
#define ETH_MDIO_PIN   18
#define ETH_TYPE       ETH_PHY_LAN8720
#define ETH_CLK_MODE   ETH_CLOCK_GPIO17_OUT

#define s2 0

WiFiUDP Udp;                      
unsigned int localUdpPort = 4196; // local port
IPAddress local_ip(192, 168, 1, 200);
IPAddress gateway(192, 168, 1, 1);
IPAddress subnet(255, 255, 255, 0);
IPAddress dns(192, 168, 1,1);

void setup()
{
  mySwitch.enableReceive(digitalPinToInterrupt(15)); 
  
  Serial.begin(115200);
  Serial.println();

  pinMode(s2,INPUT);

  // Set pinMode to OUTPUT
  pcf8574o.pinMode(P0, OUTPUT);
  pcf8574o.pinMode(P1, OUTPUT);
  pcf8574o.pinMode(P2, OUTPUT);
  pcf8574o.pinMode(P3, OUTPUT);
  pcf8574o.pinMode(P4, OUTPUT);
  pcf8574o.pinMode(P5, OUTPUT);
  pcf8574o.pinMode(P6, OUTPUT);
  pcf8574o.pinMode(P7, OUTPUT);

  Serial.print("Init pcf8574o...");
  if (pcf8574o.begin()){
    Serial.println("OK");
  }else{
    Serial.println("KO");
  }
  


 pcf8574i.pinMode(P0, INPUT);
 pcf8574i.pinMode(P1, INPUT);
 pcf8574i.pinMode(P2, INPUT);
 pcf8574i.pinMode(P3, INPUT);
 pcf8574i.pinMode(P4, INPUT);
 pcf8574i.pinMode(P5, INPUT);
 pcf8574i.pinMode(P6, INPUT);
 pcf8574i.pinMode(P7, INPUT);

  Serial.print("Init pcf8574i...");
  if (pcf8574i.begin()){
    Serial.println("OK");
  }else{
    Serial.println("KO");
  }


  Serial.print("Temperature1:");
  Serial.print(ds1.getTempC());
  Serial.print(" C /\n");

  Serial.print("Temperature2:");
  Serial.print(ds2.getTempC());
  Serial.print(" C /\n");

  Serial.print("Temperature3:");
  Serial.print(ds3.getTempC());
  Serial.print(" C /\n");

  Serial.print("Temperature4:");
  Serial.print(ds4.getTempC());
  Serial.print(" C \n");

 pcf8574o.digitalWrite(P0, HIGH);
 pcf8574o.digitalWrite(P1, HIGH);
 pcf8574o.digitalWrite(P2, HIGH);
 pcf8574o.digitalWrite(P3, HIGH);
 pcf8574o.digitalWrite(P4, HIGH);
 pcf8574o.digitalWrite(P5, HIGH);
 pcf8574o.digitalWrite(P6, HIGH);
 pcf8574o.digitalWrite(P7, HIGH);

/*
  pcf8574o.digitalWrite(P0, LOW);
  delay(300);
  pcf8574o.digitalWrite(P1, LOW);
  delay(300);
  pcf8574o.digitalWrite(P2, LOW);
  delay(300);
  pcf8574o.digitalWrite(P3, LOW);
  delay(300);
  pcf8574o.digitalWrite(P4, LOW);
  delay(300);
  pcf8574o.digitalWrite(P5, LOW);
  delay(300);
  pcf8574o.digitalWrite(P6, LOW);
  delay(300);
  pcf8574o.digitalWrite(P7, LOW); */

   
  ETH.begin(ETH_ADDR, ETH_POWER_PIN, ETH_MDC_PIN, ETH_MDIO_PIN, ETH_TYPE, ETH_CLK_MODE); //Enable ETH

  //传入参数静态IP地址,网关.DNS1,和2
  if (ETH.config(local_ip, gateway, subnet, dns, dns) == false) {
    Serial.println("LAN8720 Configuration failed.");
  }else{Serial.println("LAN8720 Configuration success.");}
  
 /* while(!((uint32_t)ETH.localIP())) //等待获取到IP
  {

  }*/
  Serial.println("Connected");
  Serial.print("IP Address:");
  Serial.println(ETH.localIP());

  Udp.begin(localUdpPort); //启用UDP监听以接收数据
}

void loop()
{
 uint8_t val1 = pcf8574i.digitalRead(P0);
 uint8_t val2 = pcf8574i.digitalRead(P1);
 uint8_t val3 = pcf8574i.digitalRead(P2);
 uint8_t val4 = pcf8574i.digitalRead(P3);
 uint8_t val5 = pcf8574i.digitalRead(P4);
 uint8_t val6 = pcf8574i.digitalRead(P5);
 uint8_t val7 = pcf8574i.digitalRead(P6);
 uint8_t val8 = pcf8574i.digitalRead(P7);
 uint8_t val_s2 = digitalRead(s2);


  
  int packetSize = Udp.parsePacket(); //获取当前队首数据包长度
  if (packetSize)                     //如果有数据可用
  {
    char buf[packetSize];
    Udp.read(buf, packetSize); //读取当前包数据

    Serial.println();
    Serial.print("Received: ");
    Serial.println(buf);
    Serial.print("From IP: ");
    Serial.println(Udp.remoteIP());
    Serial.print("From Port: ");
    Serial.println(Udp.remotePort());

    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort()); //准备发送数据
    Udp.print("Received: ");    //复制数据到发送缓存
    Udp.write((const uint8_t*)buf, packetSize); //复制数据到发送缓存
    Udp.endPacket();            //发送数据
  }


//------------------------------------
 if (val1==LOW) pcf8574o.digitalWrite(P0, LOW); else pcf8574o.digitalWrite(P0, HIGH);
 if (val2==LOW) pcf8574o.digitalWrite(P1, LOW); else pcf8574o.digitalWrite(P1, HIGH);
 if (val3==LOW) pcf8574o.digitalWrite(P2, LOW); else pcf8574o.digitalWrite(P2, HIGH);
 if (val4==LOW) pcf8574o.digitalWrite(P3, LOW); else pcf8574o.digitalWrite(P3, HIGH);
 if (val5==LOW) pcf8574o.digitalWrite(P4, LOW); else pcf8574o.digitalWrite(P4, HIGH);
 if (val6==LOW) pcf8574o.digitalWrite(P5, LOW); else pcf8574o.digitalWrite(P5, HIGH);
 if (val7==LOW) pcf8574o.digitalWrite(P6, LOW); else pcf8574o.digitalWrite(P6, HIGH);
 if (val8==LOW) pcf8574o.digitalWrite(P7, LOW); else pcf8574o.digitalWrite(P7, HIGH);
 if (val_s2==LOW) 
   {
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort()); //准备发送数据
    Udp.printf("Temperature1= %f C Temperature2= %f C Temperature3= %f C Temperature4= %f C\n",ds1.getTempC(),ds2.getTempC(),ds3.getTempC(),ds4.getTempC());    
    Udp.endPacket();  
   }
//-------------------------------------
  if (mySwitch.available()) {

    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort()); //准备发送数据
    
    Serial.print("Received ");
    Serial.print( mySwitch.getReceivedValue() );
    Udp.printf("Received %d\n",mySwitch.getReceivedValue());  
    Serial.print(" / ");
    Serial.print( mySwitch.getReceivedBitlength() );
    Serial.print("bit ");
    Udp.printf("%d bit\n",mySwitch.getReceivedBitlength());  
    Serial.print("Protocol: ");
    Serial.println( mySwitch.getReceivedProtocol() );
    Udp.printf("Protocol:%d",mySwitch.getReceivedProtocol()); 
    
    Udp.endPacket();            //发送数据 
    mySwitch.resetAvailable();
  }
//-------------------------------------
  if (analogRead(ANALOG_A1)>0) 
  {
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort()); //准备发送数据
    Udp.printf("Current Reading A1 on Pin(%d)=%d\n",ANALOG_A1,analogRead(ANALOG_A1));    //复制数据到发送缓存
   // Udp.write((const uint8_t*)buf, packetSize); //复制数据到发送缓存
    Udp.endPacket();            //发送数据
    
    Serial.printf("Current Reading A1 on Pin(%d)=%d\n",ANALOG_A1,analogRead(ANALOG_A1));
  }
  if (analogRead(ANALOG_A2)>0) 
  {
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort()); //准备发送数据
    Udp.printf("Current Reading A2 on Pin(%d)=%d\n",ANALOG_A2,analogRead(ANALOG_A2));    //复制数据到发送缓存
   // Udp.write((const uint8_t*)buf, packetSize); //复制数据到发送缓存
    Udp.endPacket();            //发送数据 
    
    Serial.printf("Current Reading A2 on Pin(%d)=%d\n",ANALOG_A2,analogRead(ANALOG_A2));
  }
  delay(30);
  
} 
