/*
 * @FileName: 
 * @Author: 
 * @Email:  
 * @LastEditors: 
 * @Date: 
 * @LastEditTime: 
 * @Copyright: 
 * @Company: 
 * @Description: This demo is based on the Arduino Esp32 , and the board are controlled by the Tuya Smart App. 
 *               
 * @Github:
 */
#include "PCF8574.h"
#include <DS18B20.h>
#include <TuyaWifi.h>
#include <SoftwareSerial.h>
#include "EEPROM.h"

#include <ETH.h> 
#include <WiFiUdp.h>

#define ETH_ADDR        0
#define ETH_POWER_PIN  -1
#define ETH_MDC_PIN    23
#define ETH_MDIO_PIN   18
#define ETH_TYPE       ETH_PHY_LAN8720
#define ETH_CLK_MODE   ETH_CLOCK_GPIO17_OUT

WiFiUDP Udp;                      //Create UDP object
unsigned int localUdpPort = 4196; //local port
IPAddress local_ip(192, 168, 123, 200);
IPAddress gateway(192, 168, 123, 1);
IPAddress subnet(255, 255, 255, 0);
IPAddress dns(192, 168, 123, 1);

const int Cur_mR = 1000;  //1000; 
const int Volt_mR = 28700;   //28700; 
 
String phone = "00000000000";  // replace with your mobile phone number


unsigned char pid[] = {"d8vwzka9smrcjznp"};
unsigned char mcu_ver[] = {"1.0.0"};

//============================================
String incomingData;
String message;
DS18B20 ds(14);
TuyaWifi my_device;
PCF8574 pcf8574_o(0x24,4,5);
PCF8574 pcf8574_i(0x22,4,5);

//============================================
#define  M433_Head         "LC:"
//#define  M433_Head_Addr    "LC:5754"

#define  ADDRESS_M433_KEY_1    0
#define  ADDRESS_M433_KEY_2    10
#define  ADDRESS_M433_KEY_3    20
#define  ADDRESS_M433_KEY_4    30
#define  ADDRESS_M433_KEY_5    40
#define  ADDRESS_M433_KEY_6    50
#define  ADDRESS_M433_KEY_7    60
#define  ADDRESS_M433_KEY_8    70

#define  ADDRESS_PASSWORD      80
#define  ADDRESS_ADMIN_PHONE1   90
#define  ADDRESS_ADMIN_PHONE2   110
#define  ADDRESS_ADMIN_PHONE3   130
#define  ADDRESS_ADMIN_PHONE4   150
#define  ADDRESS_ADMIN_PHONE5   170
#define  ADDRESS_ADMIN_PHONE6   190

#define  ADDRESS_INI_SIG      210     

#define  ADDRESS_M433_KEY_9    220   //all on
#define  ADDRESS_M433_KEY_10   230   //all off

#define DISABLE   0
#define ENABLE   1

uint16_t  io0_num = 0;
uint16_t  CRC16_Data = 0;
uint8_t  CRC16_Data_H = 0;
uint8_t  CRC16_Data_L = 0;

unsigned char eNe_state = 0;
unsigned char gsm_state = 0;

unsigned char switch_1_state = 0;
unsigned char switch_2_state = 0;
unsigned char switch_3_state = 0;
unsigned char switch_4_state = 0;
unsigned char switch_5_state = 0;
unsigned char switch_6_state = 0;
unsigned char switch_7_state = 0;
unsigned char switch_8_state = 0;

unsigned char input_1_state = 0;
unsigned char input_2_state = 0;
unsigned char input_3_state = 0;
unsigned char input_4_state = 0;
unsigned char input_5_state = 0;
unsigned char input_6_state = 0;
unsigned char input_7_state = 0;
unsigned char input_8_state = 0;

unsigned long dp_value_add_ele_1_value = 0;
unsigned long dp_value_add_ele_2_value = 0;
unsigned long dp_value_add_ele_3_value = 0;
unsigned long dp_value_add_ele_4_value = 0;
unsigned long dp_value_cur_current_1_value = 0;
unsigned long dp_value_cur_current_2_value = 0;
unsigned long dp_value_cur_current_3_value = 0;
unsigned long dp_value_cur_current_4_value = 0;
unsigned long dp_value_cur_power_1_value = 0;
unsigned long dp_value_cur_power_2_value = 0;
unsigned long dp_value_cur_power_3_value = 0;
unsigned long dp_value_cur_power_4_value = 0;
unsigned long dp_value_cur_voltage_1_value = 0;
unsigned long dp_value_cur_voltage_2_value = 0;
unsigned long dp_value_cur_voltage_3_value = 0;
unsigned long dp_value_cur_voltage_4_value = 0;

unsigned long dp_value_temp_value = 0;

//unsigned char ini_state = 1;

const uint8_t Relay1 = 0; 
const uint8_t Relay2 = 1; 
const uint8_t Relay3 = 2; 
const uint8_t Relay4 = 3; 
const uint8_t Relay5 = 4; 
const uint8_t Relay6 = 5; 
const uint8_t Relay7 = 6; 
const uint8_t Relay8 = 7; 

/* Data point define */

#define DPID_SWITCH_1   1
#define DPID_SWITCH_2   2
#define DPID_SWITCH_3   3
#define DPID_SWITCH_4   4
#define DPID_SWITCH_5   5
#define DPID_SWITCH_6   6
#define DPID_SWITCH_7   123
#define DPID_SWITCH_8   124

#define DPID_ADD_ELE_1      17
#define DPID_ADD_ELE_2      125
#define DPID_ADD_ELE_3      126
#define DPID_ADD_ELE_4      127
#define DPID_CUR_CURRENT_1  18
#define DPID_CUR_CURRENT_2  128
#define DPID_CUR_CURRENT_3  129
#define DPID_CUR_CURRENT_4  130
#define DPID_CUR_POWER_1    19
#define DPID_CUR_POWER_2    131
#define DPID_CUR_POWER_3    132
#define DPID_CUR_POWER_4    133
#define DPID_CUR_VOLTAGE_1  20
#define DPID_CUR_VOLTAGE_2  134
#define DPID_CUR_VOLTAGE_3  135
#define DPID_CUR_VOLTAGE_4  136
#define DPID_TEMP_VAL       137

#define DPID_INPUT_8   115
#define DPID_INPUT_7   116
#define DPID_INPUT_6   117
#define DPID_INPUT_5   118
#define DPID_INPUT_4   119
#define DPID_INPUT_3   120
#define DPID_INPUT_2   121
#define DPID_INPUT_1   122

#define  TUYA_RX_PIN  16
#define  TUYA_TX_PIN  13
#define  M433_RX_PIN  32
#define  USB_TX_PIN   1
#define  USB_RX_PIN   3
#define  GSM_RX_PIN   35
#define  GSM_TX_PIN   15
#define  ENE1_RX_PIN   39
#define  ENE1_TX_PIN   12
#define  ENE2_RX_PIN   36
#define  ENE2_TX_PIN   33
#define  M485_TX_PIN   2
#define  M485_RX_PIN   34

/* Stores all DPs and their types. PS: array[][0]:dpid, array[][1]:dp type. 
 *                                     dp type(TuyaDefs.h) : DP_TYPE_RAW, DP_TYPE_BOOL, DP_TYPE_VALUE, DP_TYPE_STRING, DP_TYPE_ENUM, DP_TYPE_BITMAP
*/
unsigned char dp_array[][2] =
{
  {DPID_SWITCH_1, DP_TYPE_BOOL},{DPID_SWITCH_2, DP_TYPE_BOOL},{DPID_SWITCH_3, DP_TYPE_BOOL},{DPID_SWITCH_4, DP_TYPE_BOOL},{DPID_SWITCH_5, DP_TYPE_BOOL},{DPID_SWITCH_6, DP_TYPE_BOOL},
  {DPID_SWITCH_7, DP_TYPE_BOOL},{DPID_SWITCH_8, DP_TYPE_BOOL},
  {DPID_INPUT_1, DP_TYPE_BOOL},{DPID_INPUT_2, DP_TYPE_BOOL},{DPID_INPUT_3, DP_TYPE_BOOL},{DPID_INPUT_4, DP_TYPE_BOOL},{DPID_INPUT_5, DP_TYPE_BOOL},{DPID_INPUT_6, DP_TYPE_BOOL},
  {DPID_INPUT_7, DP_TYPE_BOOL},{DPID_INPUT_8, DP_TYPE_BOOL},
  {DPID_ADD_ELE_1, DP_TYPE_VALUE},{DPID_ADD_ELE_2, DP_TYPE_VALUE},{DPID_ADD_ELE_3, DP_TYPE_VALUE},{DPID_ADD_ELE_4, DP_TYPE_VALUE},
  {DPID_CUR_CURRENT_1, DP_TYPE_VALUE},{DPID_CUR_CURRENT_2, DP_TYPE_VALUE},{DPID_CUR_CURRENT_3, DP_TYPE_VALUE},{DPID_CUR_CURRENT_4, DP_TYPE_VALUE},
  {DPID_CUR_POWER_1, DP_TYPE_VALUE},{DPID_CUR_POWER_2, DP_TYPE_VALUE},{DPID_CUR_POWER_3, DP_TYPE_VALUE},{DPID_CUR_POWER_4, DP_TYPE_VALUE},
  {DPID_CUR_VOLTAGE_1, DP_TYPE_VALUE},{DPID_CUR_VOLTAGE_2, DP_TYPE_VALUE},{DPID_CUR_VOLTAGE_3, DP_TYPE_VALUE},{DPID_CUR_VOLTAGE_4, DP_TYPE_VALUE},
  {DPID_TEMP_VAL, DP_TYPE_VALUE},
};

/* last time */
unsigned long last_time = 0;
unsigned long eNe_last_time = 0;
unsigned long Temp_last_time = 0;
unsigned long Alarm_last_time = 0;
unsigned long M433_last_time = 0;
unsigned long Io_last_time = 0;
unsigned long test_time = 0;
unsigned long io0_last_time = 0;

String indata="";
String indata_433="";
String indata_485="";
String old_indata_433="";

String  M433_KEY_1="";    
String  M433_KEY_2="";    
String  M433_KEY_3="";    
String  M433_KEY_4="";    
String  M433_KEY_5="";    
String  M433_KEY_6="";    
String  M433_KEY_7="";    
String  M433_KEY_8="";    
String  M433_KEY_9="";    
String  M433_KEY_10="";    

String val="";
String outdata="";
String relay_outdata="";
String subval="";
String key_val_433="";
String password="";
String admin_phone1="";
String admin_phone2="";
String admin_phone3="";
String admin_phone4="";
String admin_phone5="";
String admin_phone6="";
String admin_phone_new="";
String admin_phone_temp="";
String answer_phone="";
String ini_sig="";

int numsubval[6]={0};
int address = 0;
int string_index_num = 0;
int string_index_begin = 0;
int string_index_end = 0;
int string_index_temp = 0;

SoftwareSerial eNe1;
SoftwareSerial eNe2;

void setup() 
{
  // Serial 2 with 485 for test
  Serial2.begin(9600,SERIAL_8N1,M485_RX_PIN,M485_TX_PIN);
  delay(100);
  Serial2.println("485Test-OK");
  delay(500);
   indata_485 = Serial2.readString(); 

  // Serial 0 with tuyawifi
  Serial.begin(9600,SERIAL_8N1,TUYA_RX_PIN,TUYA_TX_PIN);
  // Serial 1 with gsm
  Serial1.begin(115200,SERIAL_8N1,GSM_RX_PIN,GSM_TX_PIN);
  // Serial 2 with 433 & USB(FOR PRINT DEBU)
  Serial2.begin(9600,SERIAL_8N1,M433_RX_PIN,USB_TX_PIN);

  eNe1.begin(4800, SWSERIAL_8N1, ENE1_RX_PIN, ENE1_TX_PIN, false, 64);
  eNe2.begin(4800, SWSERIAL_8N1, ENE2_RX_PIN, ENE2_TX_PIN, false, 64);
   eNe1.listen();
  //eNe2.listen();
  
  delay(500);
  Serial2.print(indata_485); 
  //------------------------------------------------------------------for Eth setup
 ETH.begin(ETH_ADDR, ETH_POWER_PIN, ETH_MDC_PIN, ETH_MDIO_PIN, ETH_TYPE, ETH_CLK_MODE); //start with ETH

  // write confir for static IP, gateway,subnet,dns1,dns2
  if (ETH.config(local_ip, gateway, subnet, dns, dns) == false) {
    Serial2.println("LAN8720 Configuration failed.");
  }else{Serial2.println("LAN8720 Configuration success.");}
  
 /* while(!((uint32_t)ETH.localIP())) //wait for IP
  {

  }*/
  Serial2.println("Connected");
  Serial2.print("IP Address:");
  Serial2.println(ETH.localIP());

  Udp.begin(localUdpPort); //begin UDP listener
  //------------------------------------------------------------------for Eth setup

  pcf8574_o.pinMode(P0, OUTPUT);
  pcf8574_o.pinMode(P1, OUTPUT);
  pcf8574_o.pinMode(P2, OUTPUT);
  pcf8574_o.pinMode(P3, OUTPUT);
  pcf8574_o.pinMode(P4, OUTPUT);
  pcf8574_o.pinMode(P5, OUTPUT);
  pcf8574_o.pinMode(P6, OUTPUT);
  pcf8574_o.pinMode(P7, OUTPUT);

  pcf8574_i.pinMode(P0, INPUT);
  pcf8574_i.pinMode(P1, INPUT);
  pcf8574_i.pinMode(P2, INPUT);
  pcf8574_i.pinMode(P3, INPUT);
  pcf8574_i.pinMode(P4, INPUT);
  pcf8574_i.pinMode(P5, INPUT);
  pcf8574_i.pinMode(P6, INPUT);
  pcf8574_i.pinMode(P7, INPUT);

  Serial2.print("Init pcf8574_output...");
  if (pcf8574_o.begin()){
    Serial2.println("OK");
  }else{
    Serial2.println("KO");
       }

 Serial2.print("Init pcf8574_input...");
  if (pcf8574_i.begin()){
    Serial2.println("OK");
  }else{
    Serial2.println("KO");
       }
 
 pcf8574_o.digitalWrite(P0, HIGH); 
 pcf8574_o.digitalWrite(P1, HIGH);
 pcf8574_o.digitalWrite(P2, HIGH);
 pcf8574_o.digitalWrite(P3, HIGH);
 pcf8574_o.digitalWrite(P4, HIGH);
 pcf8574_o.digitalWrite(P5, HIGH);
 pcf8574_o.digitalWrite(P6, HIGH);
 pcf8574_o.digitalWrite(P7, HIGH);

 Serial2.println(ds.getTempC());
 Serial2.println("start test");

 Serial2.println("\nTesting EEPROM Library\n");
  if (!EEPROM.begin(1000)) {
    Serial2.println("Failed to initialise EEPROM");
    //Serial2.println("Restarting...");
    delay(1000);
    //ESP.restart();
  }

  //Enter the PID and MCU software version
  my_device.init(pid, mcu_ver);
  //incoming all DPs and their types array, DP numbers
  my_device.set_dp_cmd_total(dp_array, 33);
  //register DP download processing callback function
  my_device.dp_process_func_register(dp_process);
  //register upload all DP callback function
  my_device.dp_update_all_func_register(dp_update_all);

  /* set tuya module pin 16 as led, set tuya module pin 28 as connect wifi key.
   * Long press 5s to enter networking mode.
  */
  my_device.set_state_pin(16, 28);

  Serial1.print("AT+QURCCFG=\"urcport\",\"uart1\"\r");  //Set urc port
  delay(500);
  Serial1.print("AT+QINGCFG=\"smsincoming\",1\r");  //en urc 
  delay(500);
  Serial1.print("AT+CMGF=1\r");  //Set text mode
  delay(500);
  Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
  delay(500);
  last_time = millis();
  eNe_last_time = last_time;
  Temp_last_time = last_time;
  Alarm_last_time = last_time;
  M433_last_time = last_time;
  io0_last_time = last_time;
  eNe_state = 0;

  address = ADDRESS_M433_KEY_1;
  M433_KEY_1 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_1);
  address = ADDRESS_M433_KEY_2;
  M433_KEY_2 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_2);
  address = ADDRESS_M433_KEY_3;
  M433_KEY_3 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_3);
  address = ADDRESS_M433_KEY_4;
  M433_KEY_4 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_4);
  address = ADDRESS_M433_KEY_5;
  M433_KEY_5 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_5);
  address = ADDRESS_M433_KEY_6;
  M433_KEY_6 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_6);
  address = ADDRESS_M433_KEY_7;
  M433_KEY_7 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_7);
  address = ADDRESS_M433_KEY_8;
  M433_KEY_8 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_8);
  address = ADDRESS_M433_KEY_9;
  M433_KEY_9 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_9);
  address = ADDRESS_M433_KEY_10;
  M433_KEY_10 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_10);
  
  address = ADDRESS_INI_SIG;   
  ini_sig = EEPROM.readString(address); 
  if(ini_sig != "inied")
  {
      address = ADDRESS_PASSWORD;   
      password = "0000";
      EEPROM.writeString(address, password);

      address = ADDRESS_ADMIN_PHONE1;   
      admin_phone1 = "00000000000";
      EEPROM.writeString(address, admin_phone1);
  
      address = ADDRESS_ADMIN_PHONE2;   
      admin_phone2 = "00000000000";
      EEPROM.writeString(address, admin_phone2);
  
      address = ADDRESS_ADMIN_PHONE3;   
      admin_phone3 = "00000000000";
      EEPROM.writeString(address, admin_phone3);

      address = ADDRESS_ADMIN_PHONE4;   
      admin_phone4 = "00000000000";
      EEPROM.writeString(address, admin_phone4);

      address = ADDRESS_ADMIN_PHONE5;   
      admin_phone5 = "00000000000";
      EEPROM.writeString(address, admin_phone5);

      address = ADDRESS_ADMIN_PHONE6;   
      admin_phone6 = "00000000000";
      EEPROM.writeString(address, admin_phone6);

      address = ADDRESS_INI_SIG;   
      ini_sig = "inied";
      EEPROM.writeString(address, ini_sig);

      EEPROM.commit();
  }

  pinMode(0, INPUT_PULLUP);

  do
  {  
    outdata = "123456";
    outdata[0] = 0xA5;
    outdata[1] = 0x39;
    outdata[2] = 0x42;
    outdata[3] = 0x00;
    outdata[4] = 0x00;
    outdata[5] = 0xDF;
    eNe1.print(outdata);
   delay(1);
    outdata = "123456";
    outdata[0] = 0xA5;
    outdata[1] = 0x38;
    outdata[2] = 0x3C;
    outdata[3] = 0x00;
    outdata[4] = 0x00;
    outdata[5] = 0xE6;
    eNe1.print(outdata);
   delay(1);
    outdata = "123456";
    outdata[0] = 0xA5;
    outdata[1] = 0x39;
    outdata[2] = 0x42;
    outdata[3] = 0x00;
    outdata[4] = 0x00;
    outdata[5] = 0xDF;
    eNe1.print(outdata);
   delay(1);
    outdata = "123456";
    outdata[0] = 0xA5;
    outdata[1] = 0x3A;
    outdata[2] = 0x01;
    outdata[3] = 0x00;
    outdata[4] = 0x00;
    outdata[5] = 0x1F;
    eNe1.print(outdata);
   delay(1);
    outdata = "123456";
    outdata[0] = 0xA5;
    outdata[1] = 0x39;
    outdata[2] = 0x00;
    outdata[3] = 0x00;
    outdata[4] = 0x00;
    outdata[5] = 0x21;
    eNe1.print(outdata);
   delay(500);
    outdata = "12";
    outdata[0] = 0x55;
    outdata[1] = 0x25;
    eNe1.print(outdata);

   indata="";
   val="";   
   delay(500);
   indata = eNe1.readString(); // Get the data from the serial port.
   Serial2.print(indata);
   Serial2.print("INI_ENE");
   } while(indata[0]==0x00);
 
   Serial2.print("INI_ENE_OK");
 
   indata="";
   val="";   

}

void loop() 
{ 
//-------------------------------------------------------for UDP test
    int packetSize = Udp.parsePacket(); //get package size
  if (packetSize)                     //if have received data
  {
    char buf[packetSize];
    Udp.read(buf, packetSize); //read current data

    Serial2.println();
    Serial2.print("Received: ");
    Serial2.println(buf);
    Serial2.print("From IP: ");
    Serial2.println(Udp.remoteIP());
    Serial2.print("From Port: ");
    Serial2.println(Udp.remotePort());

    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort()); //ready to send data
    Udp.print("Received: ");    
    Udp.write((const uint8_t*)buf, packetSize); //copy data to sender buffer
    Udp.endPacket();            //send data
  }
//---------------------------------------------------------for UDP test
  if(digitalRead(0) == HIGH)
  {
   io0_num = 0;
  }

  if((digitalRead(0) == LOW)&&((millis()-io0_last_time)>50))
  {
   io0_num = io0_num + 1 ;
   io0_last_time = millis();
   if(io0_num>100)
    {
      Serial2.println("Reset GSM Password to 0000");
      address = ADDRESS_PASSWORD;   
      password = "0000";
      EEPROM.writeString(address, password);

      address = ADDRESS_ADMIN_PHONE1;   
      admin_phone1 = "00000000000";
      EEPROM.writeString(address, admin_phone1);
  
      address = ADDRESS_ADMIN_PHONE2;   
      admin_phone2 = "00000000000";
      EEPROM.writeString(address, admin_phone2);
  
      address = ADDRESS_ADMIN_PHONE3;   
      admin_phone3 = "00000000000";
      EEPROM.writeString(address, admin_phone3);

      address = ADDRESS_ADMIN_PHONE4;   
      admin_phone4 = "00000000000";
      EEPROM.writeString(address, admin_phone4);

      address = ADDRESS_ADMIN_PHONE5;   
      admin_phone5 = "00000000000";
      EEPROM.writeString(address, admin_phone5);

      address = ADDRESS_ADMIN_PHONE6;   
      admin_phone6 = "00000000000";
      EEPROM.writeString(address, admin_phone6);

      EEPROM.commit();
      
      io0_num = 0; 
      //Serial2.println(password);
      while(digitalRead(0) == LOW)
      {
        
      }  
    }
  }

  
  //Serial2.println("gsm-begin");
  //test_time = millis();
 
  //receive_message();
  if (Serial1.available() > 0)
  {
    delay(10); 
    incomingData = Serial1.readString(); // Get the data from the serial port.
    Serial2.print(incomingData); 

 if(incomingData.indexOf("+CMTI:")>=0)
  {
    Serial1.println("AT+CMGR=0");  //delete all SMS on SIM card
    delay(100); 
   
   address = ADDRESS_PASSWORD;
   password = EEPROM.readString(address); 

   address = ADDRESS_ADMIN_PHONE1;
   admin_phone1 = EEPROM.readString(address); 
   address = ADDRESS_ADMIN_PHONE2;
   admin_phone2 = EEPROM.readString(address); 
   address = ADDRESS_ADMIN_PHONE3;
   admin_phone3 = EEPROM.readString(address); 
   address = ADDRESS_ADMIN_PHONE4;
   admin_phone4 = EEPROM.readString(address); 
   address = ADDRESS_ADMIN_PHONE5;
   admin_phone5 = EEPROM.readString(address); 
   address = ADDRESS_ADMIN_PHONE6;
   admin_phone6 = EEPROM.readString(address); 

  }

 if((string_index_temp = incomingData.indexOf("+CMGR:"))>=0)
  {
    string_index_begin = incomingData.indexOf(",", string_index_temp);
    string_index_begin = string_index_begin + 2 ;
    string_index_end   = incomingData.indexOf(",", string_index_begin);
    string_index_end = string_index_end - 1 ;
    answer_phone = incomingData.substring(string_index_begin, string_index_end);
    Serial2.println("password="); 
    Serial2.print(password); 
    Serial2.println("answer_phone="); 
    Serial2.print(answer_phone); 

    if(((admin_phone1 == "00000000000")&&(admin_phone2 == "00000000000")&&(admin_phone3 == "00000000000")\
    &&(admin_phone4 == "00000000000")&&(admin_phone5 == "00000000000")&&(admin_phone5 == "00000000000"))||(answer_phone == admin_phone1)\
    ||(answer_phone == admin_phone2)||(answer_phone == admin_phone3)||(answer_phone == admin_phone4)||(answer_phone == admin_phone5)\
    ||(answer_phone == admin_phone6))
    {

  //deal with gsm command
  if((string_index_num=incomingData.indexOf("kc"+password+"new"))>=0)
  {
    password = incomingData.substring(string_index_num+9,string_index_num+13);
    
    address = ADDRESS_PASSWORD;   
    EEPROM.writeString(address, password);
    EEPROM.commit();

    message = "new password is " + password;
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

 else if((string_index_num=incomingData.indexOf("kc"+password+"set"))>=0)
  {
     //admin_phone_new = incomingData.substring(string_index_num+9,string_index_num+20);
 
     admin_phone_new = "" ; 
     for(int i=0;i<30;i++)
     {
      admin_phone_temp = incomingData.substring(string_index_num+9+i,string_index_num+10+i);
      if((admin_phone_temp=="\n")||(admin_phone_temp=="\r"))
       {
        break; 
       }
      admin_phone_new = admin_phone_new + admin_phone_temp; 
     }
 
    Serial2.println("admin_phone_new="); 
    Serial2.print(admin_phone_new); 
  
    if(admin_phone1=="00000000000")
    {
     admin_phone1 = admin_phone_new;
     address = ADDRESS_ADMIN_PHONE1;   
     EEPROM.writeString(address, admin_phone1);
     EEPROM.commit();
     message = "manager " + admin_phone1 + " set ok";
     send_message(message);
    }
    else if(admin_phone2=="00000000000")
    {
     admin_phone2 = admin_phone_new;
     address = ADDRESS_ADMIN_PHONE2;   
     EEPROM.writeString(address, admin_phone2);
     EEPROM.commit();
     message = "manager " + admin_phone2 + " set ok";
     send_message(message);
    }
    else if(admin_phone3=="00000000000")
    {
     admin_phone3 = admin_phone_new;
     address = ADDRESS_ADMIN_PHONE3;   
     EEPROM.writeString(address, admin_phone3);
     EEPROM.commit();
     message = "manager " + admin_phone3 + " set ok";
     send_message(message);
    }
    else if(admin_phone4=="00000000000")
    {
     admin_phone4 = admin_phone_new;
     address = ADDRESS_ADMIN_PHONE4;   
     EEPROM.writeString(address, admin_phone4);
     EEPROM.commit();
     message = "manager " + admin_phone4 + " set ok";
     send_message(message);
    }
    else if(admin_phone5=="00000000000")
    {
     admin_phone5 = admin_phone_new;
     address = ADDRESS_ADMIN_PHONE5;   
     EEPROM.writeString(address, admin_phone5);
     EEPROM.commit();
     message = "manager " + admin_phone5 + " set ok";
     send_message(message);
    }
    else if(admin_phone6=="00000000000")
    {
     admin_phone6 = admin_phone_new;
     address = ADDRESS_ADMIN_PHONE6;   
     EEPROM.writeString(address, admin_phone6);
     EEPROM.commit();
     message = "manager " + admin_phone6 + " set ok";
     send_message(message);
    }
    else
    {
     message = "manager " + admin_phone_new + " set err";
     send_message(message);
    }
    // Send a sms back to confirm that the relay is turned on
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }


  else if((string_index_num=incomingData.indexOf("kc"+password+"clearall"))>=0)
  {

    address = ADDRESS_ADMIN_PHONE1;   
    admin_phone1 = "00000000000";
    EEPROM.writeString(address, admin_phone1);
  
    address = ADDRESS_ADMIN_PHONE2;   
    admin_phone2 = "00000000000";
    EEPROM.writeString(address, admin_phone2);
  
    address = ADDRESS_ADMIN_PHONE3;   
    admin_phone3 = "00000000000";
    EEPROM.writeString(address, admin_phone3);

    address = ADDRESS_ADMIN_PHONE4;   
    admin_phone4 = "00000000000";
    EEPROM.writeString(address, admin_phone4);

    address = ADDRESS_ADMIN_PHONE5;   
    admin_phone5 = "00000000000";
    EEPROM.writeString(address, admin_phone5);

    address = ADDRESS_ADMIN_PHONE6;   
    admin_phone6 = "00000000000";
    EEPROM.writeString(address, admin_phone6);

    EEPROM.commit();

    message = "clear all manager ok";
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

    
  else if((string_index_num=incomingData.indexOf("kc"+password+"clear"))>=0)
  {

    admin_phone_new = incomingData.substring(string_index_num+11,string_index_num+22);
    
    if(admin_phone1==admin_phone_new)
    {
     admin_phone1 = "00000000000";
     address = ADDRESS_ADMIN_PHONE1;   
     EEPROM.writeString(address, admin_phone1);
     EEPROM.commit();
     message = "clear manager " + admin_phone_new + " ok";
     send_message(message);
    }
    else if(admin_phone2==admin_phone_new)
    {
     admin_phone2 = "00000000000";
     address = ADDRESS_ADMIN_PHONE2;   
     EEPROM.writeString(address, admin_phone2);
     EEPROM.commit();
     message = "clear manager " + admin_phone_new + " ok";
     send_message(message);
    }
    else if(admin_phone3==admin_phone_new)
    {
     admin_phone3 = "00000000000";
     address = ADDRESS_ADMIN_PHONE3;   
     EEPROM.writeString(address, admin_phone3);
     EEPROM.commit();
     message = "clear manager " + admin_phone_new + " ok";
     send_message(message);
    }
    else if(admin_phone4==admin_phone_new)
    {
     admin_phone4 = "00000000000";
     address = ADDRESS_ADMIN_PHONE4;   
     EEPROM.writeString(address, admin_phone4);
     EEPROM.commit();
     message = "clear manager " + admin_phone_new + " ok";
     send_message(message);
    }
    else if(admin_phone5==admin_phone_new)
    {
     admin_phone5 = "00000000000";
     address = ADDRESS_ADMIN_PHONE5;   
     EEPROM.writeString(address, admin_phone5);
     EEPROM.commit();
     message = "clear manager " + admin_phone_new + " ok";
     send_message(message);
    }
    else if(admin_phone6==admin_phone_new)
    {
     admin_phone6 = "00000000000";
     address = ADDRESS_ADMIN_PHONE6;   
     EEPROM.writeString(address, admin_phone6);
     EEPROM.commit();
     message = "clear manager " + admin_phone_new + " ok";
     send_message(message);
    }
    else
    {
     message = "clear manager " + admin_phone_new + " err";
     send_message(message);
    }

    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }


  else if(incomingData.indexOf("kc"+password+"inching1")>=0)
  {
    pcf8574_o.digitalWrite(P0, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P0, HIGH);
    switch_1_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);

    message = "relay 1 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"inching2")>=0)
  {
    pcf8574_o.digitalWrite(P1, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P1, HIGH);
    switch_2_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);

    message = "relay 2 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"inching3")>=0)
  {
    pcf8574_o.digitalWrite(P2, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P2, HIGH);
    switch_3_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);

    message = "relay 3 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"inching4")>=0)
  {
    pcf8574_o.digitalWrite(P3, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P3, HIGH);
    switch_4_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);

    message = "relay 4 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"inching5")>=0)
  {
    pcf8574_o.digitalWrite(P4, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P4, HIGH);
    switch_5_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);

    message = "relay 5 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"inching6")>=0)
  {
    pcf8574_o.digitalWrite(P5, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P5, HIGH);
    switch_6_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);

    message = "relay 6 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"inching7")>=0)
  {
    pcf8574_o.digitalWrite(P6, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P6, HIGH);
    switch_7_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);

    message = "relay 7 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"inching8")>=0)
  {
    pcf8574_o.digitalWrite(P7, LOW);
    delay(1000);
    pcf8574_o.digitalWrite(P7, HIGH);
    switch_8_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);

    message = "relay 8 is inching control ok";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"state")>=0)
  {
    message = "relay ";
  
    if( switch_1_state == 1) message =  message + "1=ON "; 
    else message =  message + "1=OFF ";
    if( switch_2_state == 1) message =  message + "2=ON "; 
    else message =  message + "2=OFF ";
    if( switch_3_state == 1) message =  message + "3=ON "; 
    else message =  message + "3=OFF ";
    if( switch_4_state == 1) message =  message + "4=ON "; 
    else message =  message + "4=OFF ";
    if( switch_5_state == 1) message =  message + "5=ON "; 
    else message =  message + "5=OFF ";
    if( switch_6_state == 1) message =  message + "6=ON "; 
    else message =  message + "6=OFF ";
    if( switch_7_state == 1) message =  message + "7=ON "; 
    else message =  message + "7=OFF ";
    if( switch_8_state == 1) message =  message + "8=ON "; 
    else message =  message + "8=OFF ";
    
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }

  else if(incomingData.indexOf("kc"+password+"relay1on")>=0)
  {
    pcf8574_o.digitalWrite(P0, LOW);
    switch_1_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);

    message = "relay1 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }
  
  else if(incomingData.indexOf("kc"+password+"relay1off")>=0)
  {
    pcf8574_o.digitalWrite(P0, HIGH);
    switch_1_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
    message = "relay1 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }
  
  else if(incomingData.indexOf("kc"+password+"relay2on")>=0)
  {
    pcf8574_o.digitalWrite(P1, LOW);
    switch_2_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
    message = "relay2 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }
  
  // if received command is to turn off relay
  else if(incomingData.indexOf("kc"+password+"relay2off")>=0)
  {
    pcf8574_o.digitalWrite(P1, HIGH);
    switch_2_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
    message = "relay2 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }  
  
  else if(incomingData.indexOf("kc"+password+"relay3on")>=0)
  {
    pcf8574_o.digitalWrite(P2, LOW);
    switch_3_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
    message = "relay3 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }
  
  // if received command is to turn off relay
  else if(incomingData.indexOf("kc"+password+"relay3off")>=0)
  {
    pcf8574_o.digitalWrite(P2, HIGH);
    switch_3_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
    message = "relay3 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100); 
  }  
  
  else if(incomingData.indexOf("kc"+password+"relay4on")>=0)
  {
    pcf8574_o.digitalWrite(P3, LOW);
    switch_4_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
    message = "relay4 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }
  
  // if received command is to turn off relay
  else if(incomingData.indexOf("kc"+password+"relay4off")>=0)
  {
    pcf8574_o.digitalWrite(P3, HIGH);
    switch_4_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
    message = "relay4 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }  
  
  else if(incomingData.indexOf("kc"+password+"relay5on")>=0)
  {
    pcf8574_o.digitalWrite(P4, LOW);
    switch_5_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
    message = "relay5 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }
  
  // if received command is to turn off relay
  else if(incomingData.indexOf("kc"+password+"relay5off")>=0)
  {
    pcf8574_o.digitalWrite(P4, HIGH);
    switch_5_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
    message = "relay5 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }  
  
  else if(incomingData.indexOf("kc"+password+"relay6on")>=0)
  {
    pcf8574_o.digitalWrite(P5, LOW);
    switch_6_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
    message = "relay6 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }
  
  // if received command is to turn off relay
  else if(incomingData.indexOf("kc"+password+"relay6off")>=0)
  {
    pcf8574_o.digitalWrite(P5, HIGH);
    switch_6_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
    message = "relay6 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }  
  
  else if(incomingData.indexOf("kc"+password+"relay7on")>=0)
  {
    pcf8574_o.digitalWrite(P6, LOW);
    switch_7_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
    message = "relay7 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }
  
  // if received command is to turn off relay
  else if(incomingData.indexOf("kc"+password+"relay7off")>=0)
  {
    pcf8574_o.digitalWrite(P6, HIGH);
    switch_7_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
    message = "relay7 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }  
  
  else if(incomingData.indexOf("kc"+password+"relay8on")>=0)
  {
    pcf8574_o.digitalWrite(P7, LOW);
    switch_8_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
    message = "relay8 is ON";
    // Send a sms back to confirm that the relay is turned on
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }
  
  // if received command is to turn off relay
  else if(incomingData.indexOf("kc"+password+"relay8off")>=0)
  {
    pcf8574_o.digitalWrite(P7, HIGH);
    switch_8_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
    message = "relay8 is OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }  
  
  else if(incomingData.indexOf("kc"+password+"allon")>=0)
  {
    pcf8574_o.digitalWrite(P0, LOW);
    pcf8574_o.digitalWrite(P1, LOW);
    pcf8574_o.digitalWrite(P2, LOW);
    pcf8574_o.digitalWrite(P3, LOW);
    pcf8574_o.digitalWrite(P4, LOW);
    pcf8574_o.digitalWrite(P5, LOW);
    pcf8574_o.digitalWrite(P6, LOW);
    pcf8574_o.digitalWrite(P7, LOW);
    
    switch_1_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
    switch_2_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
    switch_3_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
    switch_4_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
    switch_5_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
    switch_6_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
    switch_7_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
    switch_8_state = 1;
    my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);

    message = "All relay are ON";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }    
  
  else if(incomingData.indexOf("kc"+password+"alloff")>=0)
  {
    pcf8574_o.digitalWrite(P0, HIGH);
    pcf8574_o.digitalWrite(P1, HIGH);
    pcf8574_o.digitalWrite(P2, HIGH);
    pcf8574_o.digitalWrite(P3, HIGH);
    pcf8574_o.digitalWrite(P4, HIGH);
    pcf8574_o.digitalWrite(P5, HIGH);
    pcf8574_o.digitalWrite(P6, HIGH);
    pcf8574_o.digitalWrite(P7, HIGH);

    switch_1_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
    switch_2_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
    switch_3_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
    switch_4_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
    switch_5_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
    switch_6_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
    switch_7_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
    switch_8_state = 0;
    my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);

    message = "All relay are OFF";
    // Send a sms back to confirm that the relay is turned off
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }     
  
  else if(incomingData.indexOf("kc"+password+"temper")>=0)
  {
    
    message = "Temperature is "+String(ds.getTempC(),2)+" C";
    send_message(message);
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }   

  else if(incomingData.indexOf("CMGR")>=0)
  {
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }
      
    } 

  else
  {
    Serial1.println("AT+CMGD=1,4");  //delete all SMS on SIM card
    delay(100);     
  }
  
  }

  
  incomingData="";
  //gsm_state =0;
  }
  //Serial2.print("gsm-over=");
  //Serial2.println(millis()-test_time);
  //Serial2.println("433-begin");
  //test_time = millis();

  //sample 433 VIA SERIAL 2   
  while(Serial2.available()>0)
   {
    indata_433+=char(Serial2.read());  //read KBOX via 232
    delay(2);
    if(Serial2.available()<=0)
     {
   //DEAL 433 COMMAND 
    if(indata_433.length()>0)
  {  
     Serial2.println("433-received:");
     Serial2.println(indata_433);
     indata_433=indata_433.substring(0,11);
     val=indata_433;  
     if(val.substring(0,3)==M433_Head) 
     {
      key_val_433 =  val.substring(3,9);
   
    if((indata_433!=old_indata_433)||((indata_433==old_indata_433)&&((millis()-M433_last_time)>800)))
     {
       
      if(key_val_433==M433_KEY_1)   
      {
      
        if( switch_1_state == 0)
        {
        pcf8574_o.digitalWrite(P0, LOW);
        switch_1_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
        }
        else
        {
        pcf8574_o.digitalWrite(P0, HIGH);
        switch_1_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
        }
      }      

      if(key_val_433==M433_KEY_2)   
      {
      
        if( switch_2_state == 0)
        {
        pcf8574_o.digitalWrite(P1, LOW);
        switch_2_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        }
        else
        {
        pcf8574_o.digitalWrite(P1, HIGH);
        switch_2_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        }
      }      

      if(key_val_433==M433_KEY_3)   
      {
      
        if( switch_3_state == 0)
        {
        pcf8574_o.digitalWrite(P2, LOW);
        switch_3_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
        }
        else
        {
        pcf8574_o.digitalWrite(P2, HIGH);
        switch_3_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
        }
      }      

      if(key_val_433==M433_KEY_4)   
      {
      
        if( switch_4_state == 0)
        {
        pcf8574_o.digitalWrite(P3, LOW);
        switch_4_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        }
        else
        {
        pcf8574_o.digitalWrite(P3, HIGH);
        switch_4_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        }
      }      

      if(key_val_433==M433_KEY_5)   
      {
      
        if( switch_5_state == 0)
        {
        pcf8574_o.digitalWrite(P4, LOW);
        switch_5_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
        }
        else
        {
        pcf8574_o.digitalWrite(P4, HIGH);
        switch_5_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
        }
      }      

      if(key_val_433==M433_KEY_6)   
      {
      
        if( switch_6_state == 0)
        {
        pcf8574_o.digitalWrite(P5, LOW);
        switch_6_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
        }
        else
        {
        pcf8574_o.digitalWrite(P5, HIGH);
        switch_6_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
        }
      }      

      if(key_val_433==M433_KEY_7)   
      {
      
        if( switch_7_state == 0)
        {
        pcf8574_o.digitalWrite(P6, LOW);
        switch_7_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
        }
        else
        {
        pcf8574_o.digitalWrite(P6, HIGH);
        switch_7_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
        }
      }      

      if(key_val_433==M433_KEY_8)   
      {
      
        if( switch_8_state == 0)
        {
        pcf8574_o.digitalWrite(P7, LOW);
        switch_8_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
        }
        else
        { 
        pcf8574_o.digitalWrite(P7, HIGH);
        switch_8_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
        }
      }

      if(key_val_433==M433_KEY_9)        //all on   
      {
        pcf8574_o.digitalWrite(P0, LOW);
        switch_1_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);

        delay(30);
        
        pcf8574_o.digitalWrite(P1, LOW);
        switch_2_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P2, LOW);
        switch_3_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P3, LOW);
        switch_4_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P4, LOW);
        switch_5_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P5, LOW);
        switch_6_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P6, LOW);
        switch_7_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P7, LOW);
        switch_8_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
      
      }

      if(key_val_433==M433_KEY_10)        //all off   
      {
        pcf8574_o.digitalWrite(P0, HIGH);
        switch_1_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);

        delay(30);
        
        pcf8574_o.digitalWrite(P1, HIGH);
        switch_2_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P2, HIGH);
        switch_3_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P3, HIGH);
        switch_4_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P4, HIGH);
        switch_5_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P5, HIGH);
        switch_6_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P6, HIGH);
        switch_7_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);

        delay(30);

        pcf8574_o.digitalWrite(P7, HIGH);
        switch_8_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
      
      }
            
     }  
     old_indata_433=indata_433; 
     indata_433=""; 
     M433_last_time = millis();
     
     }
     
    }
    
   }
   }    
  
  //Serial2.print("433-over=");
  //Serial2.println(millis()-test_time);
  //Serial2.println("IO-begin");
  //test_time = millis();

//sample IO
  PCF8574::DigitalInput di = pcf8574_i.digitalReadAll();
 
  if(!((di.p0)&&(di.p1)&&(di.p2)&&(di.p3)&&(di.p4)&&(di.p5)&&(di.p6)&&(di.p7)))
  {
         if(di.p0==0)   
      {
        if( switch_1_state == 0)
        {
        switch_1_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
        pcf8574_o.digitalWrite(P0, LOW);
        }
        else
        {
        switch_1_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
        pcf8574_o.digitalWrite(P0, HIGH);
        }
      }      

      if(di.p1==0)   
      {
      
        if( switch_2_state == 0)
        {
        switch_2_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        pcf8574_o.digitalWrite(P1, LOW);
        }
        else
        {
        switch_2_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        pcf8574_o.digitalWrite(P1, HIGH);
        }
      }      

      if(di.p2==0)   
      {
      
        if( switch_3_state == 0)
        {
        switch_3_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
        pcf8574_o.digitalWrite(P2, LOW);
        }
        else
        {
        switch_3_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
        pcf8574_o.digitalWrite(P2, HIGH);
        }
      }      

      if(di.p3==0)   
      {
      
        if( switch_4_state == 0)
        {
        switch_4_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        pcf8574_o.digitalWrite(P3, LOW);
        }
        else
        {
        switch_4_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        pcf8574_o.digitalWrite(P3, HIGH);
        }
      }      

      if(di.p4==0)   
      {
      
        if( switch_5_state == 0)
        {
        switch_5_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
        pcf8574_o.digitalWrite(P4, LOW);
        }
        else
        {
        switch_5_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
        pcf8574_o.digitalWrite(P4, HIGH);
        }
      }      

      if(di.p5==0)   
      {
      
        if( switch_6_state == 0)
        {
        switch_6_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
        pcf8574_o.digitalWrite(P5, LOW);
        }
        else
        {
        switch_6_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
        pcf8574_o.digitalWrite(P5, HIGH);
        }
      }      

      if(di.p6==0)   
      {
     //Serial2.print(di.p0);
      
        if( switch_7_state == 0)
        {
        switch_7_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
        pcf8574_o.digitalWrite(P6, LOW);
        }
        else
        {
        switch_7_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
        pcf8574_o.digitalWrite(P6, HIGH);
        }
      }      

      if(di.p7==0)   
      {
      
        if( switch_8_state == 0)
        {
        switch_8_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
        pcf8574_o.digitalWrite(P7, LOW);
        }
        else
        {
        switch_8_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
        pcf8574_o.digitalWrite(P7, HIGH);
        }
      }      
  
  while(!((di.p0==1)&&(di.p1==1)&&(di.p2==1)&&(di.p3==1)&&(di.p4==1)&&(di.p5==1)&&(di.p6==1)&&(di.p7==1)))
   {
    di = pcf8574_i.digitalReadAll();

      //sample 433 VIA SERIAL 2   
  while(Serial2.available()>0)
   {
    indata_433+=char(Serial2.read());  //read KBOX via 232
    delay(2);
    if(Serial2.available()<=0)
     {
   //DEAL 433 COMMAND 
    if(indata_433.length()>0)
    {  
     indata_433=indata_433.substring(0,11);
     val=indata_433;  
     if(val.substring(0,3)==M433_Head) 
     {
      key_val_433 =  val.substring(3,9);
   
    if((indata_433!=old_indata_433)||((indata_433==old_indata_433)&&((millis()-M433_last_time)>1000)))
     {

      if((di.p0==0)&&(di.p1==0))  //1&2 =all on
    {
     address = ADDRESS_M433_KEY_9;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_2_state == 0)
        {
        switch_2_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        pcf8574_o.digitalWrite(P1, LOW);
        }
        else
        {
        switch_2_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        pcf8574_o.digitalWrite(P1, HIGH);
        }
    
    }

    else if((di.p0==0)&&(di.p3==0)) //1&4 =all off
    {
     address = ADDRESS_M433_KEY_10;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_4_state == 0)
        {
        switch_4_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        pcf8574_o.digitalWrite(P3, LOW);
        }
        else
        {
        switch_4_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        pcf8574_o.digitalWrite(P3, HIGH);
        }

    }

    else if(di.p0==0)   
    {
     address = ADDRESS_M433_KEY_1;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_1_state == 0)
        {
        switch_1_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
        pcf8574_o.digitalWrite(P0, LOW);
        }
        else
        {
        switch_1_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
        pcf8574_o.digitalWrite(P0, HIGH);
        }
    }      
    else if(di.p1==0)
    {
     address = ADDRESS_M433_KEY_2;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_2_state == 0)
        {
        switch_2_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        pcf8574_o.digitalWrite(P1, LOW);
        }
        else
        {
        switch_2_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
        pcf8574_o.digitalWrite(P1, HIGH);
        }
    
    }
    else if(di.p2==0)
    {
     address = ADDRESS_M433_KEY_3;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_3_state == 0)
        {
        switch_3_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
        pcf8574_o.digitalWrite(P2, LOW);
        }
        else
        {
        switch_3_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
        pcf8574_o.digitalWrite(P2, HIGH);
        }

    }
    else if(di.p3==0)
    {
     address = ADDRESS_M433_KEY_4;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_4_state == 0)
        {
        switch_4_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        pcf8574_o.digitalWrite(P3, LOW);
        }
        else
        {
        switch_4_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
        pcf8574_o.digitalWrite(P3, HIGH);
        }

    }
    else if(di.p4==0)
    {
     address = ADDRESS_M433_KEY_5;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_5_state == 0)
        {
        switch_5_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
        pcf8574_o.digitalWrite(P4, LOW);
        }
        else
        {
        switch_5_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
        pcf8574_o.digitalWrite(P4, HIGH);
        }

    }
    else if(di.p5==0)
    {
     address = ADDRESS_M433_KEY_6;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_6_state == 0)
        {
        switch_6_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
        pcf8574_o.digitalWrite(P5, LOW);
        }
        else
        {
        switch_6_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
        pcf8574_o.digitalWrite(P5, HIGH);
        }
     
    }
    else if(di.p6==0)
    {
     address = ADDRESS_M433_KEY_7;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_7_state == 0)
        {
        switch_7_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
        pcf8574_o.digitalWrite(P6, LOW);
        }
        else
        {
        switch_7_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
        pcf8574_o.digitalWrite(P6, HIGH);
        }
    }
    else if(di.p7==0)
    {
     address = ADDRESS_M433_KEY_8;   
     EEPROM.writeString(address, key_val_433);
     EEPROM.commit();

        if( switch_8_state == 0)
        {
        switch_8_state = 1;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
        pcf8574_o.digitalWrite(P7, LOW);
        }
        else
        {
        switch_8_state = 0;
        my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);
        pcf8574_o.digitalWrite(P7, HIGH);
        }

    }

     }
     old_indata_433=indata_433; 
     indata_433=""; 
     M433_last_time = millis();

     address = ADDRESS_M433_KEY_1;
     M433_KEY_1 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_1);
    address = ADDRESS_M433_KEY_2;
    M433_KEY_2 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_2);
    address = ADDRESS_M433_KEY_3;
    M433_KEY_3 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_3);
    address = ADDRESS_M433_KEY_4;
    M433_KEY_4 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_4);
    address = ADDRESS_M433_KEY_5;
    M433_KEY_5 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_5);
    address = ADDRESS_M433_KEY_6;
    M433_KEY_6 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_6);
    address = ADDRESS_M433_KEY_7;
    M433_KEY_7 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_7);
    address = ADDRESS_M433_KEY_8;
    M433_KEY_8 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_8);
    address = ADDRESS_M433_KEY_9;
    M433_KEY_9 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_9);
    address = ADDRESS_M433_KEY_10;
    M433_KEY_10 = EEPROM.readString(address); 
  //Serial2.println(M433_KEY_10);

    }
   }
   }
   } 
  }
  Io_last_time = millis();
  } 
  

  //Serial2.print("IO-over=");
  //Serial2.println(millis()-test_time);
  //Serial2.println("18B20-begin");
  //test_time = millis();

  
//sample temprature
 if(((millis() - Temp_last_time)>5000)&&((millis() - Io_last_time)>5000))
 {
  dp_value_temp_value=ds.getTempC();
  my_device.mcu_dp_update(DPID_TEMP_VAL, dp_value_temp_value, 1);
  Temp_last_time = millis() ;
 }

//  Serial2.print("18B20-over=");
//  Serial2.println(millis()-test_time);
//  Serial2.println("ENE-begin");
//  test_time = millis();

//sample energy
 switch (eNe_state)
{
 case 0: 
    if((millis() - eNe_last_time)>100) 
    {
     eNe1.listen();
     eNe_state=1; 
     eNe_last_time = millis();
     //Serial2.print(eNe_state);
    }
    break;     
 case 1: 
    if((millis() - eNe_last_time)>1000) 
    {
     eNe_state=2; 
     eNe_last_time = millis();
     //Serial2.print(eNe_state);
    }
    break;     
 case 2: 
    outdata = "12";
    outdata[0] = 0x55;
    outdata[1] = 0xAA;
    eNe1.print(outdata);
    eNe_state=3; 
    eNe_last_time = millis();
     //Serial2.print(eNe_state);
    break;     
 case 3: 
    if(eNe1.available()>0)
      {
        indata+=char(eNe1.read());   //read ene1

    //indata = eNe1.readString(); // Get the data from the serial port.
    eNe_last_time = millis();
     //Serial2.print(eNe_state);
     //Serial2.print(indata);
      } 
      else
      {
        if(((millis() - eNe_last_time)>4)&&(indata.length()>2))
          {
     //Serial2.print(eNe_state);
     //Serial2.print(indata);

            val=indata;   //
            
            //Serial2.print(indata);

              dp_value_add_ele_1_value=(double(indata[22]+indata[23]*256+indata[24]*65536)*16384*256*1218*1218*22*5)/36000/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_add_ele_2_value=(double(indata[25]+indata[26]*256+indata[27]*65536)*16384*256*1218*1218*22*5)/36000/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_cur_current_1_value=(double(indata[4]+indata[5]*256+indata[6]*65536)*1218*1000)/324004/Cur_mR;  //3300mR
              dp_value_cur_current_2_value=(double(indata[7]+indata[8]*256+indata[9]*65536)*1218*1000)/324004/Cur_mR;  //3300mR
              dp_value_cur_power_1_value=(double(indata[16]+indata[17]*256+indata[18]*65536)*1218*1218*22*5*10)/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_cur_power_2_value=(double(indata[19]+indata[20]*256+indata[21]*65536)*1218*1218*22*5*10)/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_cur_voltage_1_value=(double(indata[10]+indata[11]*256+indata[12]*65536)*1218*22*5*10)/79931/Volt_mR; //24900mR
              //dp_value_cur_voltage_2_value=dp_value_cur_voltage_2_value;

            Serial2.println("meter1-2 channel data:");
            Serial2.print("ele1:");
            //Serial2.println(dp_value_add_ele_1_value);
            Serial2.print(dp_value_add_ele_1_value);
            Serial2.println(" wh");
            Serial2.print("ele2:");
            //Serial2.println(dp_value_add_ele_2_value);              
            Serial2.print(dp_value_add_ele_2_value);
            Serial2.println(" wh");
            Serial2.print("current1:");
            //Serial2.println(dp_value_cur_current_1_value);
            Serial2.print(dp_value_cur_current_1_value);
            Serial2.println(" mA");
            Serial2.print("current2:");
            //Serial2.println(dp_value_cur_current_2_value);    
            Serial2.print(dp_value_cur_current_2_value);
            Serial2.println(" mA");
            Serial2.print("power1:");
            //Serial2.println(dp_value_cur_power_1_value);
            Serial2.print(dp_value_cur_power_1_value/10);
            Serial2.println(" W");
            Serial2.print("power2:");
            //Serial2.println(dp_value_cur_power_2_value);   
            Serial2.print(dp_value_cur_power_2_value/10);
            Serial2.println(" W");
            Serial2.print("voltage1:");
            //Serial2.println(dp_value_cur_voltage_1_value);   
            Serial2.print(dp_value_cur_voltage_1_value/10);
            Serial2.println(" V");
                          
            my_device.mcu_dp_update(DPID_ADD_ELE_1, dp_value_add_ele_1_value, 1);
            my_device.mcu_dp_update(DPID_ADD_ELE_2, dp_value_add_ele_2_value, 1);
            my_device.mcu_dp_update(DPID_CUR_CURRENT_1, dp_value_cur_current_1_value, 1);
            my_device.mcu_dp_update(DPID_CUR_CURRENT_2, dp_value_cur_current_2_value, 1);
            my_device.mcu_dp_update(DPID_CUR_POWER_1, dp_value_cur_power_1_value, 1);
            my_device.mcu_dp_update(DPID_CUR_POWER_2, dp_value_cur_power_2_value, 1);
            my_device.mcu_dp_update(DPID_CUR_VOLTAGE_1, dp_value_cur_voltage_1_value, 1);
            my_device.mcu_dp_update(DPID_CUR_VOLTAGE_2, dp_value_cur_voltage_1_value, 1);

          
            eNe_state=4; 
            //eNe_state=0; 
            indata="";
            eNe_last_time = millis();
          }
      }
     break;     
 case 4: 
      if((millis()-eNe_last_time)>100)
        {
          eNe2.listen();
          eNe_state=5; 
          eNe_last_time = millis();
        }
      break;     
 case 5: 
    if((millis() - eNe_last_time)>1000) 
    {
     eNe_state=6; 
     eNe_last_time = millis();
    }
    break;     
 case 6: 
    outdata = "12";
    outdata[0] = 0x55;
    outdata[1] = 0xAA;
    eNe2.print(outdata);
    eNe_state=7; 
    break;     
 case 7: 
    if(eNe2.available()>0)
      {
        indata+=char(eNe2.read());   //read ene2
        eNe_last_time = millis();
      } 
      else
      {
        if(((millis() - eNe_last_time)>4)&&(indata.length()>2))
          {
            val=indata;   //
            //Serial2.print(indata);  

              dp_value_add_ele_3_value=(double(indata[22]+indata[23]*256+indata[24]*65536)*16384*256*1218*1218*22*5)/36000/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_add_ele_4_value=(double(indata[25]+indata[26]*256+indata[27]*65536)*16384*256*1218*1218*22*5)/36000/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_cur_current_3_value=(double(indata[4]+indata[5]*256+indata[6]*65536)*1218*1000)/324004/Cur_mR;  //3300mR
              dp_value_cur_current_4_value=(double(indata[7]+indata[8]*256+indata[9]*65536)*1218*1000)/324004/Cur_mR;  //3300mR
              dp_value_cur_power_3_value=(double(indata[16]+indata[17]*256+indata[18]*65536)*1218*1218*22*5*10)/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_cur_power_4_value=(double(indata[19]+indata[20]*256+indata[21]*65536)*1218*1218*22*5*10)/4046/Cur_mR/Volt_mR; //3300mR 24900mR
              dp_value_cur_voltage_3_value=(double(indata[10]+indata[11]*256+indata[12]*65536)*1218*22*5*10)/79931/Volt_mR; //24900mR
              //dp_value_cur_voltage_4_value=dp_value_cur_voltage_3_value;

            Serial2.println("meter3-4 channel data:");
            Serial2.print("ele3:");
            //Serial2.println(dp_value_add_ele_3_value);
            Serial2.print(dp_value_add_ele_3_value);
            Serial2.println(" wh");
            Serial2.print("ele4:");
            //Serial2.println(dp_value_add_ele_4_value);              
            Serial2.print(dp_value_add_ele_4_value);
            Serial2.println(" wh");
            Serial2.print("current3:");
            //Serial2.println(dp_value_cur_current_3_value);
            Serial2.print(dp_value_cur_current_3_value);
            Serial2.println(" mA");
            Serial2.print("current4:");
            //Serial2.println(dp_value_cur_current_4_value);    
            Serial2.print(dp_value_cur_current_4_value);
            Serial2.println(" mA");
            Serial2.print("power3:");
            //Serial2.println(dp_value_cur_power_3_value);
            Serial2.print(dp_value_cur_power_3_value/10);
            Serial2.println(" W");
            Serial2.print("power4:");
            //Serial2.println(dp_value_cur_power_4_value);   
            Serial2.print(dp_value_cur_power_4_value/10);
            Serial2.println(" W");
            Serial2.print("voltage2:");
            //Serial2.println(dp_value_cur_voltage_2_value);   
            Serial2.print(dp_value_cur_voltage_3_value/10);
            Serial2.println(" V");
             
            my_device.mcu_dp_update(DPID_ADD_ELE_3, dp_value_add_ele_3_value, 1);
            my_device.mcu_dp_update(DPID_ADD_ELE_4, dp_value_add_ele_4_value, 1);
            my_device.mcu_dp_update(DPID_CUR_CURRENT_3, dp_value_cur_current_3_value, 1);
            my_device.mcu_dp_update(DPID_CUR_CURRENT_4, dp_value_cur_current_4_value, 1);
            my_device.mcu_dp_update(DPID_CUR_POWER_3, dp_value_cur_power_3_value, 1);
            my_device.mcu_dp_update(DPID_CUR_POWER_4, dp_value_cur_power_4_value, 1);
            my_device.mcu_dp_update(DPID_CUR_VOLTAGE_3, dp_value_cur_voltage_3_value, 1);
            my_device.mcu_dp_update(DPID_CUR_VOLTAGE_4, dp_value_cur_voltage_3_value, 1);
            
            eNe_state=0; 
            indata="";
            eNe_last_time = millis();
          }
      }
     break;     
}

  //Serial2.print("ENE-over=");
  //Serial2.println(millis()-test_time);
  //Serial2.println("tuya-begin");
  //test_time = millis();


 // tuya deal
  my_device.uart_service();
 delay(10);

  //Serial2.print("tuya-over=");
  //Serial2.println(millis()-test_time);
  //Serial2.println("gsm-begin");
  //test_time = millis();
}
/**
 * @description: DP download callback function.
 * @param {unsigned char} dpid
 * @param {const unsigned char} value
 * @param {unsigned short} length
 * @return {unsigned char}
 */
unsigned char dp_process(unsigned char dpid,const unsigned char value[], unsigned short length)
{
  switch(dpid) {
    case DPID_SWITCH_1:
      switch_1_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_1_state) {
        //Turn on
      pcf8574_o.digitalWrite(P0, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P0, HIGH); 
      }
        //Status changes should be reported.
    my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_2:
      switch_2_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_2_state) {
        //Turn on
      pcf8574_o.digitalWrite(P1, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P1, HIGH); 
      }
      //Status changes should be reported.
    my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_3:
      switch_3_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_3_state) {
        //Turn on
      pcf8574_o.digitalWrite(P2, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P2, HIGH); 
      }
    my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_4:
      switch_4_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_4_state) {
        //Turn on
      pcf8574_o.digitalWrite(P3, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P3, HIGH); 
      }
    my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_5:
      switch_5_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_5_state) {
        //Turn on
      pcf8574_o.digitalWrite(P4, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P4, HIGH); 
      }
    my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_6:
      switch_6_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_6_state) {
        //Turn on
      pcf8574_o.digitalWrite(P5, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P5, HIGH); 
      }
    my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_7:
      switch_7_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_7_state) {
        //Turn on
      pcf8574_o.digitalWrite(P6, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P6, HIGH); 
      }
    my_device.mcu_dp_update(dpid, value, length);
    break;

    case DPID_SWITCH_8:
      switch_8_state = my_device.mcu_get_dp_download_data(dpid, value, length); /* Get the value of the down DP command */
      if (switch_8_state) {
        //Turn on
      pcf8574_o.digitalWrite(P7, LOW); 
      } else {
        //Turn off
      pcf8574_o.digitalWrite(P7, HIGH); 
      }
    my_device.mcu_dp_update(dpid, value, length);
    break;

    default:break;
  }

  //===============================================================================
  
  return TY_SUCCESS;
}

/**
 * @description: Upload all DP status of the current device.
 * @param {*}
 * @return {*}
 */
void dp_update_all(void)
{
  my_device.mcu_dp_update(DPID_SWITCH_1, switch_1_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_2, switch_2_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_3, switch_3_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_4, switch_4_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_5, switch_5_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_6, switch_6_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_7, switch_7_state, 1);
  my_device.mcu_dp_update(DPID_SWITCH_8, switch_8_state, 1);

//  my_device.mcu_dp_update(DPID_INPUT_1, input_1_state, 1);
//  my_device.mcu_dp_update(DPID_INPUT_2, input_2_state, 1);
//  my_device.mcu_dp_update(DPID_INPUT_3, input_3_state, 1);
//  my_device.mcu_dp_update(DPID_INPUT_4, input_4_state, 1);
//  my_device.mcu_dp_update(DPID_INPUT_5, input_5_state, 1);
//  my_device.mcu_dp_update(DPID_INPUT_6, input_6_state, 1);
//  my_device.mcu_dp_update(DPID_INPUT_7, input_7_state, 1);
//  my_device.mcu_dp_update(DPID_INPUT_8, input_8_state, 1);

  my_device.mcu_dp_update(DPID_ADD_ELE_1, dp_value_add_ele_1_value, 1);
  my_device.mcu_dp_update(DPID_ADD_ELE_2, dp_value_add_ele_2_value, 1);
  my_device.mcu_dp_update(DPID_ADD_ELE_3, dp_value_add_ele_3_value, 1);
  my_device.mcu_dp_update(DPID_ADD_ELE_4, dp_value_add_ele_4_value, 1);

  my_device.mcu_dp_update(DPID_CUR_CURRENT_1, dp_value_cur_current_1_value, 1);
  my_device.mcu_dp_update(DPID_CUR_CURRENT_2, dp_value_cur_current_2_value, 1);
  my_device.mcu_dp_update(DPID_CUR_CURRENT_3, dp_value_cur_current_3_value, 1);
  my_device.mcu_dp_update(DPID_CUR_CURRENT_4, dp_value_cur_current_4_value, 1);

  //my_device.mcu_dp_update(DPID_CUR_POWER_1, dp_value_cur_power_1_value, 1);
  //my_device.mcu_dp_update(DPID_CUR_POWER_2, dp_value_cur_power_2_value, 1);
  //my_device.mcu_dp_update(DPID_CUR_POWER_3, dp_value_cur_power_3_value, 1);
  //my_device.mcu_dp_update(DPID_CUR_POWER_4, dp_value_cur_power_4_value, 1);

  my_device.mcu_dp_update(DPID_CUR_VOLTAGE_1, dp_value_cur_voltage_1_value, 1);
  my_device.mcu_dp_update(DPID_CUR_VOLTAGE_2, dp_value_cur_voltage_1_value, 1);
  my_device.mcu_dp_update(DPID_CUR_VOLTAGE_3, dp_value_cur_voltage_3_value, 1);
  my_device.mcu_dp_update(DPID_CUR_VOLTAGE_4, dp_value_cur_voltage_3_value, 1);

  my_device.mcu_dp_update(DPID_TEMP_VAL, dp_value_temp_value, 1);
}

void receive_message()
{
  Serial1.println("AT+CMGR=0");  //read first sms

  if (Serial1.available() > 0)
  {
    incomingData = Serial1.readString(); // Get the data from the serial port.
    //Serial2.print(incomingData); 
    delay(10); 
  }
}

void send_message(String message)
{
  //Serial2.println(answer_phone);    //Set the GSM Module in Text Mode
  Serial1.println("AT+CMGF=1");    //Set the GSM Module in Text Mode
  delay(100);  
  Serial1.print("AT+CMGS=\""+answer_phone+"\"\r"); //Send message
  //Serial2.print("AT+CMGS=\""+answer_phone+"\"\r"); //Send message
  delay(100);
  Serial1.print(message);   // The SMS text you want to send
  delay(100);
  Serial1.println((char)26);  // ASCII code of CTRL+Z
  delay(100);
  Serial1.println();
  delay(100);  
} 
