////////////////////////////////////
//   DEVICE-SPECIFIC LED SERVICES //
////////////////////////////////////

#include "extras/PwmPin.h"  // library of various PWM functions
#include "KC868.h"

extern KC868 kc868;

boolean Serial_ReadPin(int idx) {

  return kc868.readSwitch(idx);
}

boolean Serial_SetPin(int idx, boolean value) {

  return kc868.writeSwitch(idx,value);
}

struct DEV_LED : Service::LightBulb {

  int powerPin;  // NEW! pin with pushbutton to turn on/off LED
  int ledPin;
  SpanCharacteristic *power;  // reference to the On Characteristic


  DEV_LED(int pin)
    : Service::LightBulb() {

    power = new Characteristic::On();
    //new SpanButton(powerPin);                       // NEW! create new SpanButton to control power using pushbutton on pin number "powerPin"

    //this->ledPin=new LedPin(pin);                   // configures a PWM LED for output to the specified pin
    this->ledPin = pin;

    Serial.print("Configuring LED: Pin=");  // initialization message
    Serial.print(pin);
    Serial.print("\n");

  }  // end constructor

  boolean update() {  // update() method

    if (power->updated()) {
      LOG1("  New Power=");
      LOG1(power->getNewVal() ? "true" : "false");
    }

    LOG1("\n");
    //ledPin->set(power->getNewVal()*100);
    Serial_SetPin(ledPin, power->getNewVal());
    
    return (true);  // return true

  }  // update


};

struct DEV_ContactSensor : Service::ContactSensor {                       // Motion sensor

  SpanCharacteristic *movement;                                         // reference to the MotionDetected Characteristic
  int sensorPin;                                                        // pin number of the sensor

  DEV_ContactSensor(int sensorPin) : Service::ContactSensor() {
    
    this->sensorPin = sensorPin;
   
    int motion = kc868.readSensor(sensorPin);
    boolean state;
    if (motion == 1) state=true; else state=false;
        
    movement=new Characteristic::ContactSensorState(state);                // instantiate the MotionDetected Characteristic

  } // end constructor

  void loop() {

  }
};


//////////////////////////////////