#include "HomeSpan.h" 
#include "DEV_LED.h"     

DEV_LED *led[32];
DEV_ContactSensor *sensor[6];

KC868 kc868(&Serial2);
char devname[32];
uint8_t efuse_mac[6];

void SwitchUpdate(uint8_t idx, uint8_t state)
{
  //Serial.printf("%d : %d\n",idx,state);
  led[idx-1]->power->setVal(state);

}

void SensorUpdate(uint8_t idx, uint8_t state)
{
  //Serial.printf("Sensor %d : %d\n",idx,state);
  if(state)
    sensor[idx-1]->movement->setVal(1);
  else
    sensor[idx-1]->movement->setVal(0);
}

void setup() {

  Serial.begin(115200);

  pinMode(23, OUTPUT);

  kc868.begin(115200);
  kc868.readSwitchAll();
  kc868.setReadMode(1);
  kc868.setSwitchChangeHook(SwitchUpdate);
  kc868.setSensorChangeHook(SensorUpdate);
  

  //homeSpan.setLogLevel(2);
  homeSpan.setControlPin(0);
  homeSpan.setStatusPin(22);

  
  //char mac[30];
  esp_read_mac(efuse_mac,ESP_MAC_ETH);
  //sprintf(mac,"%02X%02X%02X%02X%02X%02X", efuse_mac[0],efuse_mac[1],efuse_mac[2],efuse_mac[3],efuse_mac[4],efuse_mac[5]);
  sprintf(devname,"HomeSpan_%02X%02X",efuse_mac[4],efuse_mac[5]);
  homeSpan.begin(Category::Bridges,devname);
  
  new SpanAccessory();  
    new Service::AccessoryInformation();
      new Characteristic::Identify(); 

  for(int n=1;n<=32;n++){
    char name[18];
    sprintf(name,"Switch%d-%02X%02X",n,efuse_mac[4],efuse_mac[5]);
    new SpanAccessory();                                                          
      new Service::AccessoryInformation();
        new Characteristic::Identify(); 
        new Characteristic::Name(name);

      led[n-1]=new DEV_LED(n);          
  }

  for(int n=1;n<=6;n++){
    char name[18];
    sprintf(name,"Sensor%d-%02X%02X",n,efuse_mac[4],efuse_mac[5]);
    new SpanAccessory();                                                          
      new Service::AccessoryInformation();
        new Characteristic::Identify(); 
        new Characteristic::Name(name);

      sensor[n-1]=new DEV_ContactSensor(n);          
  }

} // end of setup()

//////////////////////////////////////

void loop(){
  if(WiFi.isConnected())
  {
    digitalWrite(23, HIGH);//turn on led when wifi connected
  }
  else
  {
    digitalWrite(23, LOW);//turn off led
  }
  homeSpan.poll();
  kc868.poll();
} // end of loop()


  
  
