/********************************/
/*KC868-A6工厂测试程序  2022-08-25
功能：上电后，按Rest按键一次，继电器轮巡打开和关闭，红色指示灯亮和灭，同时RS232串口打印温度和时钟，485输出 485 send is OK!,电表输出5V和5V；
     按Download（S2） 按键，通过RS232打印 Download key is ok !；
     依次触发输入端，对应继电器打开或关闭；
     依次触发A1-14，其中A1 A2数据在2400左右；A3 A4数据在4000左右；
     RS232和RS485上位机发送任意数据，返回则接收正常；
     
*/
/*********************************/

#include "Arduino.h"
#include "PCF8574.h"
#include <DS18B20.h>
#include "RTClib.h"
#include <Wire.h>
#define A6_SDA 4
#define A6_SCL 15
DS18B20 ds1(32);  //channel-1-DS18b20
DS18B20 ds2(33);  //channel-2-DS18b20

// Set input i2c address
PCF8574 pcf8574_IN(0x22,A6_SDA,A6_SCL);
// Set output i2c address
PCF8574 pcf8574_RE(0x24,A6_SDA,A6_SCL);

RTC_DS1307 rtc;
char daysOfTheWeek[7][12] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

#define DAC1 26
#define DAC2 25

#define ANALOG_A1   36
#define ANALOG_A2   39
#define ANALOG_A3   34
#define ANALOG_A4   35

void setup() {
  
 /**********初始化读取DS18B20**********/
  Serial1.begin(115200,SERIAL_8N1,16,17);  //  IO16   232RX   IO17 232TX
  Serial1.println("**********");
  Serial1.printf("T1: %.2f\n",ds1.getTempC());
  Serial1.printf("T2: %.2f\n",ds2.getTempC());
  delay(100);
/************************************/
/****************DS1307  print the Time**************/
Wire.setPins(A6_SDA,A6_SCL);// set the I2C pins

  if (! rtc.begin()) {
    while (1) delay(10);
  }
  if (! rtc.isrunning()) {
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  }

    DateTime now = rtc.now();
    Serial1.print(now.year(), DEC);
    Serial1.print('/');
    Serial1.print(now.month(), DEC);
    Serial1.print('/');
    Serial1.print(now.day(), DEC);
    Serial1.print(" (");
    Serial1.print(daysOfTheWeek[now.dayOfTheWeek()]);
    Serial1.print(") ");
    Serial1.print(now.hour(), DEC);
    Serial1.print(':');
    Serial1.print(now.minute(), DEC);
    Serial1.print(':');
    Serial1.print(now.second(), DEC);
    Serial1.println();
    delay(500);
/************************************/  
  pinMode(0,INPUT);
 /*************************RS485初始输出*******************************/
 Serial2.begin(115200,SERIAL_8N1,14,27);  //  IO14   485RX   IO27 485TX
 Serial2.printf("485 send is OK!\n"); // Enter your print string
 
/************ADC初始化*******************************/
  pinMode(ANALOG_A1,INPUT);
  pinMode(ANALOG_A2,INPUT);
  pinMode(ANALOG_A3,INPUT);
  pinMode(ANALOG_A4,INPUT);
/***************************************************/ 

  dacWrite(DAC1,127);
  delay(100);
  dacWrite(DAC2,127);
  delay(100);
/****************INPUT初始化************************/
 for(int i =0;i<6;i++)
 {
    pcf8574_IN.pinMode(i,INPUT);
 }
 /***********************************************/
/*******************OUTPUT初始化*******************/ 
 for(int i =0;i<6;i++)
 {
    pcf8574_RE.pinMode(i,OUTPUT);
 }
 /************************************************/
   pcf8574_IN.begin();
   pcf8574_RE.begin();


/*********初始继电器检测***********/   
  pcf8574_RE.digitalWrite(P0,LOW);delay(100);
  pcf8574_RE.digitalWrite(P1,LOW);delay(100);
  pcf8574_RE.digitalWrite(P2,LOW);delay(100);
  pcf8574_RE.digitalWrite(P3,LOW);delay(100);
  pcf8574_RE.digitalWrite(P4,LOW);delay(100);
  pcf8574_RE.digitalWrite(P5,LOW);delay(100);
  if(analogRead(ANALOG_A1)!=0)   {Serial1.printf("Current Reading A1 on Pin(%d)=%d\n",ANALOG_A1,analogRead(ANALOG_A1));delay(10);}
  if(analogRead(ANALOG_A2)!=0)  {Serial1.printf("Current Reading A2 on Pin(%d)=%d\n",ANALOG_A2,analogRead(ANALOG_A2));delay(10);}
  if(analogRead(ANALOG_A3)!=0)  {Serial1.printf("Current Reading A3 on Pin(%d)=%d\n",ANALOG_A3,analogRead(ANALOG_A3));delay(10);}
  if(analogRead(ANALOG_A4)!=0)  {Serial1.printf("Current Reading A4 on Pin(%d)=%d\n",ANALOG_A4,analogRead(ANALOG_A4));delay(10);}
delay(1000);
for(int i =0;i<6;i++)
{
  pcf8574_RE.digitalWrite(i,HIGH);
  delay(100);
}
/**********************************/

}
void loop() {
  
 while(Serial1.available()>0)
   {
    Serial1.print((char)Serial1.read());//print rs485 receive
   }
  delay(100);
while(Serial2.available()>0)
   {
    Serial2.print((char)Serial2.read());//print rs485 receive
   }
  delay(100);
  
  if(digitalRead(0)==LOW)
  {
    delay(20);
    if(digitalRead(0)==LOW)
    {
      Serial1.printf("Download key is ok !\n");
    }
  }

  //255= 10V
  dacWrite(DAC1,0);
  delay(100);
  dacWrite(DAC2,0);
  delay(100);
  
 uint8_t val1 = pcf8574_IN.digitalRead(P0);
 uint8_t val2 = pcf8574_IN.digitalRead(P1);
 uint8_t val3 = pcf8574_IN.digitalRead(P2);
 uint8_t val4 = pcf8574_IN.digitalRead(P3);
 uint8_t val5 = pcf8574_IN.digitalRead(P4);
 uint8_t val6 = pcf8574_IN.digitalRead(P5);
 
 if (val1==LOW)   {pcf8574_RE.digitalWrite(P0,LOW);delay(10);}
              else pcf8574_RE.digitalWrite(P0,HIGH);delay(10);
  if (val2==LOW)   {pcf8574_RE.digitalWrite(P1,LOW);delay(10);}
              else pcf8574_RE.digitalWrite(P1,HIGH);delay(10);
  if (val3==LOW)   {pcf8574_RE.digitalWrite(P2,LOW);delay(10);}
              else pcf8574_RE.digitalWrite(P2,HIGH);delay(10);
  if (val4==LOW)   {pcf8574_RE.digitalWrite(P3,LOW);delay(10);}
              else pcf8574_RE.digitalWrite(P3,HIGH);delay(10);
  if (val5==LOW)   {pcf8574_RE.digitalWrite(P4,LOW);delay(10);}
              else pcf8574_RE.digitalWrite(P4,HIGH);delay(10);
   if (val6==LOW)   {pcf8574_RE.digitalWrite(P5,LOW);delay(10);}
              else pcf8574_RE.digitalWrite(P5,HIGH); delay(10);
  if(analogRead(ANALOG_A1)!=0)  {Serial1.printf("A1 = %d\n",analogRead(ANALOG_A1));delay(10);}
  if(analogRead(ANALOG_A2)!=0)  {Serial1.printf("A2 = %d\n",analogRead(ANALOG_A2));delay(10);}
  if(analogRead(ANALOG_A3)!=0)  {Serial1.printf("A3 = %d\n",analogRead(ANALOG_A3));delay(10);}
  if(analogRead(ANALOG_A4)!=0)  {Serial1.printf("A4 = %d\n",analogRead(ANALOG_A4));delay(10);}



}
