#include <ModbusMaster.h>
#include <Arduino.h>
#include <TuyaWifi.h>
#include "HardwareSerial.h"
//---------RS485 setting
#define DEBUG   1

#define SERIAL_BAUD   9600
#define RX_PIN    32
#define TX_PIN    33
#define SERIAL_NUM  2
#define SLAVE_ADDR  1
#define READ_ADDR  0 
#define READ_NUM   2  

HardwareSerial My485Serial(SERIAL_NUM);
ModbusMaster node;
uint16_t rcv_buf[READ_NUM] = {0};
float get_value[2] = {0.0};

/* Current device DP values */
int temperature = 0;
int humidity = 0;

static void ReadInputRegs(void)
{
  uint8_t result = node.readInputRegisters(READ_ADDR, READ_NUM);
  if (result == node.ku8MBSuccess) {//if communicate successful then
    #if DEBUG
    Serial1.print("Result:");  
    #endif
    
    for (uint8_t j = 0; j < READ_NUM; j++)
    {
      rcv_buf[j] = node.getResponseBuffer(j);
      #if 0 ///just for debug.
      Serial1.print(" 0x");
      Serial1.print( rcv_buf[j], HEX );//display data in hex.
      #endif 
    }
    get_value[0] = rcv_buf[0]/10;///huminity 
    get_value[1] = rcv_buf[1]/10;///temperature 

    temperature = rcv_buf[0];
    humidity = get_value[1];
    
    #if DEBUG
    Serial1.print("humi.<");  
    Serial1.print(get_value[1]);
    Serial1.print("%>"); 
    Serial1.print(" temp.<");  
    Serial1.print(get_value[0]);
    Serial1.println("°c>");
    #endif

    //delay(300); 
  }
  else 
  {
    node.clearResponseBuffer();
  }
}

//---RS485 setting end----

TuyaWifi my_device;



/* Current LED status */
unsigned char led_state = 0;
/* Connect network button pin */
int key_pin = 25;

/* Data point define */
#define DPID_TEMP_CURRENT     1
#define DPID_HUMIDITY_CURRENT 2

#define LED_WiFi  26
//#define LED_User  33



/* Stores all DPs and their types. PS: array[][0]:dpid, array[][1]:dp type. 
 *                                     dp type(TuyaDefs.h) : DP_TYPE_RAW, DP_TYPE_BOOL, DP_TYPE_VALUE, DP_TYPE_STRING, DP_TYPE_ENUM, DP_TYPE_BITMAP
*/
unsigned char dp_array[][2] =
{
  {DPID_TEMP_CURRENT, DP_TYPE_VALUE},
  {DPID_HUMIDITY_CURRENT, DP_TYPE_VALUE},
};

unsigned char pid[] = {"dpyditdgaadmqw8m"};
unsigned char mcu_ver[] = {"1.0.0"};

/* last time */
unsigned long last_time = 0;

void setup() 
{

  My485Serial.begin(SERIAL_BAUD, SERIAL_8N1, RX_PIN, TX_PIN); //RS485 serial port
  node.begin(SLAVE_ADDR,My485Serial);
  Serial.begin(9600,SERIAL_8N1,22,19);  //Tuya module serial port
  Serial1.begin(115200,SERIAL_8N1,3,1);   //USB serial port

  
  // Serial with tuyawifi
  
  

  //Initialize led port, turn off led.
  pinMode(LED_WiFi, OUTPUT);
  digitalWrite(LED_WiFi, LOW);

/*  pinMode(LED_User, OUTPUT);
  digitalWrite(LED_User, LOW);*/

  //Initialize networking keys.
  pinMode(key_pin, INPUT_PULLUP);

  //Enter the PID and MCU software version
  my_device.init(pid, mcu_ver);
  //incoming all DPs and their types array, DP numbers
  my_device.set_dp_cmd_total(dp_array, 2);
  //register DP download processing callback function
  my_device.dp_process_func_register(dp_process);
  //register upload all DP callback function
  my_device.dp_update_all_func_register(dp_update_all);
  
  //delay(300);
  last_time = millis();
}

void loop() 
{
  ReadInputRegs();  // read RS485 sensor
  my_device.uart_service();

  //Enter the connection network mode when Pin7 is pressed.
  if (digitalRead(key_pin) == LOW) {
    delay(80);
    if (digitalRead(key_pin) == LOW) {
      my_device.mcu_set_wifi_mode(SMART_CONFIG);
    }
  }
  /* LED blinks when network is being connected */
  if ((my_device.mcu_get_wifi_work_state() != WIFI_LOW_POWER) && (my_device.mcu_get_wifi_work_state() != WIFI_CONN_CLOUD) && (my_device.mcu_get_wifi_work_state() != WIFI_SATE_UNKNOW)) {
    if (millis()- last_time >= 500) {
      last_time = millis();

      if (led_state == LOW) {
        led_state = HIGH;
      } else {
        led_state = LOW;
      }
      digitalWrite(LED_WiFi, led_state);
    }
  }

  /* report the temperature and humidity */
  if ((my_device.mcu_get_wifi_work_state() == WIFI_CONNECTED) || (my_device.mcu_get_wifi_work_state() == WIFI_CONN_CLOUD)) {
    my_device.mcu_dp_update(DPID_TEMP_CURRENT, temperature, 1);
    my_device.mcu_dp_update(DPID_HUMIDITY_CURRENT, humidity, 1);
  }

  delay(1000);
}

/**
 * @description: DP download callback function.
 * @param {unsigned char} dpid
 * @param {const unsigned char} value
 * @param {unsigned short} length
 * @return {unsigned char}
 */
unsigned char dp_process(unsigned char dpid,const unsigned char value[], unsigned short length)
{
  /* all DP only report */
  return TY_SUCCESS;
}

/**
 * @description: Upload all DP status of the current device.
 * @param {*}
 * @return {*}
 */
void dp_update_all(void)
{
  my_device.mcu_dp_update(DPID_TEMP_CURRENT, temperature, 1);
  my_device.mcu_dp_update(DPID_HUMIDITY_CURRENT, humidity, 1);
}
