#include <HardwareSerial.h>

// 定义串口
HardwareSerial SimSerial(1); // 使用硬件串口1（GPIO9和GPIO10）

void setup() {
  // 初始化USB串口（默认串口0）
  Serial.begin(115200);
  while (!Serial) {
    ; // 等待USB串口连接
  }

  // 初始化SIM7600串口
  SimSerial.begin(115200, SERIAL_8N1, 9, 10); // RX=GPIO9, TX=GPIO10
  //Serial.println("ESP32-S3 begin work");
}

void loop() {
  // 如果从电脑接收到数据，转发给SIM7600模块
  if (Serial.available()) {
    while (Serial.available()) {
      char data = Serial.read();
      SimSerial.write(data);
    }
  }

  // 如果从SIM7600模块接收到数据，转发给电脑
  if (SimSerial.available()) {
    while (SimSerial.available()) {
      char data = SimSerial.read();
      Serial.write(data);
    }
  }
}
