#include "Arduino.h"

// Define RS232 pins
#define RS232_TXD 9 // TX pin
#define RS232_RXD 10 // RX pin

// Define RS232 communication
HardwareSerial RS232(1); // Use UART1

void setup() {
  // Initialize RS232 serial communication
  RS232.begin(9600, SERIAL_8N1, RS232_RXD, RS232_TXD); // Baud rate 9600, 8 data bits, no parity, 1 stop bit
  Serial.begin(115200); // Debug serial communication

  Serial.println("RS232 Communication Initialized");
}

void loop() {
  static unsigned long lastSendTime = 0;

  // Send a string to RS232 every 5 seconds
  if (millis() - lastSendTime >= 5000) {
    RS232.println("This is KinCony A6v3");
    Serial.println("Sent: This is KinCony A6v3");
    lastSendTime = millis();
  }

  // Check if data is available from RS232
  while (RS232.available()) {
    String receivedData = RS232.readStringUntil('\n'); // Read data from RS232
    RS232.println(receivedData); // Echo the received data back to RS232
    Serial.println("Received and echoed: " + receivedData); // Print the received data to the debug console
  }
}
