/**
 * @brief Simple example to read multiple digital inputs using ESP32
 * @details This program demonstrates how to read digital input states
 *          from GPIO18, GPIO8, GPIO4, GPIO5, GPIO6, and GPIO38 of an ESP32 development board.
 *
 * Made by KinCony IoT: https://www.kincony.com
 */

// Define the GPIO pins for digital inputs
#define INPUT1_PIN 18  // GPIO18
#define INPUT2_PIN 8   // GPIO8
#define INPUT3_PIN 4   // GPIO4
#define INPUT4_PIN 5   // GPIO5
#define INPUT5_PIN 6   // GPIO6
#define INPUT6_PIN 38  // GPIO38

void setup() {
    // Initialize the serial communication for debugging
    Serial.begin(115200);
    Serial.println("ESP32 Digital Input Read Example");

    // Set the input pins as INPUT
    pinMode(INPUT1_PIN, INPUT);
    pinMode(INPUT2_PIN, INPUT);
    pinMode(INPUT3_PIN, INPUT);
    pinMode(INPUT4_PIN, INPUT);
    pinMode(INPUT5_PIN, INPUT);
    pinMode(INPUT6_PIN, INPUT);
}

void loop() {
    // Read the state of the digital inputs
    int state1 = digitalRead(INPUT1_PIN);
    int state2 = digitalRead(INPUT2_PIN);
    int state3 = digitalRead(INPUT3_PIN);
    int state4 = digitalRead(INPUT4_PIN);
    int state5 = digitalRead(INPUT5_PIN);
    int state6 = digitalRead(INPUT6_PIN);

    // Print the states to the Serial Monitor
    Serial.print("GPIO18 State: ");
    Serial.println(state1);
    Serial.print("GPIO8 State: ");
    Serial.println(state2);
    Serial.print("GPIO4 State: ");
    Serial.println(state3);
    Serial.print("GPIO5 State: ");
    Serial.println(state4);
    Serial.print("GPIO6 State: ");
    Serial.println(state5);
    Serial.print("GPIO38 State: ");
    Serial.println(state6);

    // Wait for 500 milliseconds before reading again
    delay(500);
}
