/**
 * @brief Example to control relays based on digital input states using ESP32
 * @details This program reads the states of two digital inputs (GPIO16, GPIO17)
 *          and controls two relays (GPIO40, GPIO39) accordingly.
 *
 * Made by KinCony IoT: https://www.kincony.com
 */

// Define the GPIO pins for digital inputs
#define INPUT1_PIN 16  // GPIO16 for Digital Input 1
#define INPUT2_PIN 17  // GPIO17 for Digital Input 2

// Define the GPIO pins for relays
#define RELAY1_PIN 40  // GPIO40 for Relay 1
#define RELAY2_PIN 39  // GPIO39 for Relay 2

void setup() {
    // Initialize the serial communication for debugging
    Serial.begin(115200);
    Serial.println("ESP32 Input-Controlled Relay Example");

    // Set the input pins as INPUT
    pinMode(INPUT1_PIN, INPUT);
    pinMode(INPUT2_PIN, INPUT);

    // Set the relay pins as OUTPUT
    pinMode(RELAY1_PIN, OUTPUT);
    pinMode(RELAY2_PIN, OUTPUT);

    // Turn off both relays at startup (assuming active LOW relays)
    digitalWrite(RELAY1_PIN, HIGH);
    digitalWrite(RELAY2_PIN, HIGH);
}

void loop() {
    // Read the state of the digital inputs
    int state1 = digitalRead(INPUT1_PIN);
    int state2 = digitalRead(INPUT2_PIN);

    // Control the relays based on input states
    digitalWrite(RELAY1_PIN, state1 == HIGH ? LOW : HIGH); // Activate relay if input is HIGH
    digitalWrite(RELAY2_PIN, state2 == HIGH ? LOW : HIGH); // Activate relay if input is HIGH

    // Print the states to the Serial Monitor
    Serial.print("Digital Input 1 State: ");
    Serial.println(state1);
    Serial.print("Digital Input 2 State: ");
    Serial.println(state2);

    // Wait for 100 milliseconds before reading again
    delay(100);
}
