#include "Arduino.h"
#include "PCF8574.h"
#include "CRC16.h"
#include "CRC.h"

#define  RS485Address   0x01

#define  USB_TX_PIN   1
#define  USB_RX_PIN   3
#define  M485_TX_PIN   33
#define  M485_RX_PIN   32

// Set i2c address
PCF8574 pcf8574o(0x24,4,5);
PCF8574 pcf8574i(0x22,4,5);

unsigned long switch_32_1_state = 0;

uint16_t  CRC16_Data = 0;
uint8_t  CRC16_Data_H = 0;
uint8_t  CRC16_Data_L = 0;

unsigned char Rs485_Str[30] = {0};

String indata="";
String val="";

String outdata="";

void setup()
{
  // Serial 0 with USB
  Serial.begin(9600,SERIAL_8N1,USB_RX_PIN,USB_TX_PIN);
  // Serial 2 with 485 
  Serial2.begin(9600,SERIAL_8N1,M485_RX_PIN,M485_TX_PIN);

  Serial.println();

  // Set pinMode to OUTPUT
  pcf8574o.pinMode(P0, OUTPUT);
  pcf8574o.pinMode(P1, OUTPUT);
  pcf8574o.pinMode(P2, OUTPUT);
  pcf8574o.pinMode(P3, OUTPUT);
  pcf8574o.pinMode(P4, OUTPUT);
  pcf8574o.pinMode(P5, OUTPUT);
  pcf8574o.pinMode(P6, OUTPUT);
  pcf8574o.pinMode(P7, OUTPUT);

  Serial.print("Init pcf8574o...");
  if (pcf8574o.begin()){
    Serial.println("OK");
  }else{
    Serial.println("KO");
  }


 pcf8574i.pinMode(P0, INPUT);
 pcf8574i.pinMode(P1, INPUT);
 pcf8574i.pinMode(P2, INPUT);
 pcf8574i.pinMode(P3, INPUT);
 pcf8574i.pinMode(P4, INPUT);
 pcf8574i.pinMode(P5, INPUT);
 pcf8574i.pinMode(P6, INPUT);
 pcf8574i.pinMode(P7, INPUT);

  Serial.print("Init pcf8574i...");
  if (pcf8574i.begin()){
    Serial.println("OK");
  }else{
    Serial.println("KO");
  }


 pcf8574o.digitalWrite(P0, HIGH);
 pcf8574o.digitalWrite(P1, HIGH);
 pcf8574o.digitalWrite(P2, HIGH);
 pcf8574o.digitalWrite(P3, HIGH);
 pcf8574o.digitalWrite(P4, HIGH);
 pcf8574o.digitalWrite(P5, HIGH);
 pcf8574o.digitalWrite(P6, HIGH);
 pcf8574o.digitalWrite(P7, HIGH);

 
}

void loop()
{
//------------------------------------

//sample IO
  PCF8574::DigitalInput di = pcf8574i.digitalReadAll();
 
  if(!((di.p0)&&(di.p1)&&(di.p2)&&(di.p3)&&(di.p4)&&(di.p5)&&(di.p6)&&(di.p7)))
  {
      if(di.p0==0)   
      {
        if(((switch_32_1_state&0x01)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P0, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(1-1));
        }
        else
        {
        pcf8574o.digitalWrite(P0, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(1-1)));
        }
 
      }      


      if(di.p1==0)   
      {
      
        if(((switch_32_1_state&0x02)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P1, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(2-1));
        }
        else
        {
        pcf8574o.digitalWrite(P1, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(2-1)));
        }

      }      


      if(di.p2==0)   
      {
      
        if(((switch_32_1_state&0x04)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P2, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(3-1));
        }
        else
        {
        pcf8574o.digitalWrite(P2, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(3-1)));
        }

      }      


      if(di.p3==0)   
      {
      
        if(((switch_32_1_state&0x08)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P3, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(4-1));
        }
        else
        {
        pcf8574o.digitalWrite(P3, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(4-1)));
        }

   }      


      if(di.p4==0)   
      {
        if(((switch_32_1_state&0x10)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P4, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(5-1));
        }
        else
        {
        pcf8574o.digitalWrite(P4, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(5-1)));
        }

      }      


      if(di.p5==0)   
      {
        if(((switch_32_1_state&0x20)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P5, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(6-1));
        }
        else
        {
        pcf8574o.digitalWrite(P5, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(6-1)));
        }

      }      


      if(di.p6==0)   
      {
        if(((switch_32_1_state&0x40)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P6, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(7-1));
        }
        else
        {
        pcf8574o.digitalWrite(P6, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(7-1)));
        }

      }      


      if(di.p7==0)   
      {
      
        if(((switch_32_1_state&0x80)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P7, LOW);
        switch_32_1_state = switch_32_1_state | (1<<(8-1));
        }
        else
        {
        pcf8574o.digitalWrite(P7, HIGH);
        switch_32_1_state = switch_32_1_state & (~(1<<(8-1)));
        }

      }    


     rs485_feedback();
 }

  while(!((di.p0==1)&&(di.p1==1)&&(di.p2==1)&&(di.p3==1)&&(di.p4==1)&&(di.p5==1)&&(di.p6==1)&&(di.p7==1)))
   {
    di = pcf8574i.digitalReadAll();
   }
//------------------------------------
//read RS485 data 
 while(Serial2.available()>0)
   {
    indata+=char(Serial2.read());   //read  via 485
    delay(2);
    if(Serial2.available()<=0)
     {
        //Serial2.print(indata);
     }
   }    
//------------------------------------
//deal with RS485 data
if(indata.length()>0)
  {
     val=indata;   //
               Serial.print(indata);

      //----Key control relay command  
    if((val[0]==RS485Address)&&(val[1]==0x10)&&(val[2]==0x00)&&(val[3]==0x0A)&&(val[4]==0x00)&&(val[5]==0x06)&&(val[6]==0x0C))
    {
        val[7] = (((val[7]>>4) & 0x0F)*10)+(val[7]& 0x0F); //bcd to hex
        val[8] = val[8] & 0x01;
        switch_32_1_state = switch_32_1_state ^ (val[8]<<(val[7]-1));

        val[9]  = (((val[9]>>4) & 0x0F)*10)+(val[9]& 0x0F); //bcd to hex
        val[10] = val[10] & 0x01;
        switch_32_1_state = switch_32_1_state ^ (val[10]<<(val[9]-1));
        
        val[11]  = (((val[11]>>4) & 0x0F)*10)+(val[11]& 0x0F); //bcd to hex
        val[12] = val[12] & 0x01;
        switch_32_1_state = switch_32_1_state ^ (val[12]<<(val[11]-1));
        
        val[13]  = (((val[13]>>4) & 0x0F)*10)+(val[13]& 0x0F); //bcd to hex
        val[14] = val[14] & 0x01;
        switch_32_1_state = switch_32_1_state ^ (val[14]<<(val[13]-1));
       
        val[15]  = (((val[15]>>4) & 0x0F)*10)+(val[15]& 0x0F); //bcd to hex
        val[16] = val[16] & 0x01;
        switch_32_1_state = switch_32_1_state ^ (val[16]<<(val[15]-1));

        val[17]  = (((val[17]>>4) & 0x0F)*10)+(val[17]& 0x0F); //bcd to hex
        val[18] = val[18] & 0x01;
        switch_32_1_state = switch_32_1_state ^ (val[18]<<(val[17]-1));

        //switch_1_state
        if(((switch_32_1_state&0x01)?1:0) == 0 ) 
        {
        pcf8574o.digitalWrite(P0, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P0, LOW);
        }

        //switch_2_state
        if(((switch_32_1_state&0x02)?1:0) == 0 ) 
        {
        pcf8574o.digitalWrite(P1, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P1, LOW);
        }

        //switch_3_state
        if(((switch_32_1_state&0x04)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P2, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P2, LOW);
        }

        //switch_4_state
        if(((switch_32_1_state&0x08)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P3, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P3, LOW);
        }

        //switch_5_state
        if(((switch_32_1_state&0x10)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P4, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P4, LOW);
        }

        //switch_6_state
        if(((switch_32_1_state&0x20)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P5, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P5, LOW);
        }

        //switch_7_state
        if(((switch_32_1_state&0x40)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P6, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P6, LOW);
        }

        //switch_8_state
        if(((switch_32_1_state&0x80)?1:0) == 0 )
        {
        pcf8574o.digitalWrite(P7, HIGH);
        }
        else
        {
        pcf8574o.digitalWrite(P7, LOW);
        }

     rs485_feedback();
    
    }

  }
    
    
    indata="";   //clear indata
//--------------------------------------------------

  
  delay(30);
  
} 
 
 void rs485_feedback(void)
 {
       Rs485_Str[0] = RS485Address;
       Rs485_Str[1] = 0x03;
       Rs485_Str[2] = 0x06;
       Rs485_Str[3] = 0x55;
       Rs485_Str[4] = 0xAA;
       Rs485_Str[5] = (int)((switch_32_1_state >> 24) & 0xFF);
       Rs485_Str[6] = (int)((switch_32_1_state >> 16) & 0xFF);
       Rs485_Str[7] = (int)((switch_32_1_state >> 8) & 0xFF);
       Rs485_Str[8] = (int)(switch_32_1_state & 0xFF);
       
       outdata = "12345678901";
       outdata[0] = Rs485_Str[0];
       outdata[1] = Rs485_Str[1];
       outdata[2] = Rs485_Str[2];
       outdata[3] = Rs485_Str[3];
       outdata[4] = Rs485_Str[4];
       outdata[5] = Rs485_Str[5];
       outdata[6] = Rs485_Str[6];
       outdata[7] = Rs485_Str[7];
       outdata[8] = Rs485_Str[8];
     
       CRC16_Data = (crc16((uint8_t *) Rs485_Str, 9, 0x8005, 0xFFFF, 0, true, true));
       CRC16_Data_H = CRC16_Data/256;
       CRC16_Data_L = CRC16_Data%256;
       outdata[9] = CRC16_Data_L;
       outdata[10] = CRC16_Data_H;
       Serial.print(outdata);
       Serial2.print(outdata);
 }
