#include <Arduino.h>
//SD library
#include <SD.h>
#include <FS.h>
#include <SPI.h>
//HSPI or VSPI define
//#define  hspi
#define  vspi
#ifdef vspi
SPIClass sdSPI(VSPI);
#define SD_MISO     19
#define SD_MOSI     23
#define SD_SCLK     18
#define SD_CS       5

#else
SPIClass sdSPI(HSPI);
#define SD_MISO     12
#define SD_MOSI     13
#define SD_SCLK     14
#define SD_CS       15

#endif
void SD_init();
 
void setup()
{
  Serial.begin(115200);
  delay(500);
#ifdef  hspi 
  Serial.println("please insert SD card");
  delay(12000);
#endif 
  SD_init();

}
 
void loop() {
  //print SD card information
  Serial.printf("SD card total size： %lluMB \n", SD.cardSize() / (1024 * 1024)); 
  Serial.printf("File system whole size： %lluB \n", SD.totalBytes());
  Serial.printf("File system used： %lluB \n", SD.usedBytes());
  delay(5000);
}
 
 
void SD_init() {
  //load file system
   sdSPI.begin(SD_SCLK, SD_MISO, SD_MOSI, SD_CS);
  if (!SD.begin(SD_CS, sdSPI))
  {
    // if(!SD.begin()){
    Serial.println("load SD card error");
    return;
  }
  uint8_t cardType = SD.cardType();
 
  if (cardType == CARD_NONE)
  {
    Serial.println("not connected SD card");
    return;
  }
  else if (cardType == CARD_MMC)
  {
    Serial.println("MMC card");
  }
  else if (cardType == CARD_SD)
  {
    Serial.println("SDSC card");
  }
  else if (cardType == CARD_SDHC)
  {
    Serial.println("SDHC card");
  }
  else
  {
    Serial.println("unknow card");
  }
}
