/*
  Version: 1.0.0
  Created by KinCony (https://www.kincony.com)
  Description: 
    This program monitors the state of selected GPIO pins (47, 48, 38, 39, 40, 41, 0) 
    and prints the state of each pin when there is a change (HIGH to LOW or LOW to HIGH).
  Date: 2024-12-24
*/

#include "Arduino.h"

// Define GPIO pins to be monitored as input
const int gpioPins[] = {47, 48, 38, 39, 40, 41, 0};
const int numPins = sizeof(gpioPins) / sizeof(gpioPins[0]);
int lastStates[numPins]; // To store the previous states of each pin

void setup() {
  Serial.begin(115200);  // Initialize serial communication at 115200 baud

  // Set all specified GPIO pins as input
  for (int i = 0; i < numPins; i++) {
    pinMode(gpioPins[i], INPUT);  // Set each GPIO pin to INPUT mode
    lastStates[i] = digitalRead(gpioPins[i]);  // Initialize last state to current state
  }

  Serial.println("GPIO Monitoring Started...");  // Print message to indicate the monitoring has started
}

void loop() {
  // Loop through each pin and check for state change
  for (int i = 0; i < numPins; i++) {
    int currentState = digitalRead(gpioPins[i]);  // Read the current state of the pin

    // If the state has changed (from LOW to HIGH or HIGH to LOW)
    if (currentState != lastStates[i]) {
      // Print the pin number and its new state
      Serial.print("GPIO ");
      Serial.print(gpioPins[i]);
      Serial.print(" changed to: ");
      Serial.println(currentState == HIGH ? "HIGH" : "LOW");

      // Update the last state to the current state
      lastStates[i] = currentState;
    }
  }

  // Add a small delay to reduce the load on the MCU and debounce the inputs
  delay(50);  // Delay for 50 milliseconds
}
