// Made by KinCony IoT: https://www.kincony.com

#include <Wire.h>        // Include I2C communication library
#include <PCF8575.h>     // Include PCF8575 library

#define SDA_PIN 8        // I2C SDA pin
#define SCL_PIN 18       // I2C SCL pin

#define RELAY1 14        // Relay 1 (PCF8575 CH15)
#define RELAY2 15       // Relay 2 (PCF8575 CH16)

#define I2C_ADDRESS 0x22 // I2C address of PCF8575

PCF8575 pcf8575(I2C_ADDRESS); // Create PCF8575 object

void setup() {
    Wire.begin(SDA_PIN, SCL_PIN); // Initialize I2C bus
    Serial.begin(115200);
    Serial.println("PCF8575 Relay Control: Starting...");

    pcf8575.begin(); // Initialize PCF8575

    // Initialize relay state, default OFF (HIGH)
    pcf8575.write(RELAY1, HIGH);
    pcf8575.write(RELAY2, HIGH);
    Serial.println("All relays are OFF");
}

void loop() {
    Serial.println("Turning Relay 1 ON");
    pcf8575.write(RELAY1, LOW); // Turn ON relay 1
    delay(2000);
    Serial.println("Turning Relay 1 OFF");
    pcf8575.write(RELAY1, HIGH); // Turn OFF relay 1
    delay(2000);

    Serial.println("Turning Relay 2 ON");
    pcf8575.write(RELAY2, LOW); // Turn ON relay 2
    delay(2000);
    Serial.println("Turning Relay 2 OFF");
    pcf8575.write(RELAY2, HIGH); // Turn OFF relay 2
    delay(2000);
}